/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BackgroundActionRegistry
extends Collection<BackgroundAction>
implements BackgroundActionListener {
    private static final Logger log = Logger.getLogger(BackgroundActionRegistry.class);
    private static final long serialVersionUID = 1721336643608575003L;
    private static BackgroundActionRegistry global = null;
    private static final Object lock = new Object();
    private final Set<BackgroundAction> running = new LinkedHashSet<BackgroundAction>();
    private final Object identity = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackgroundActionRegistry global() {
        Object object = lock;
        synchronized (object) {
            if (null == global) {
                global = new BackgroundActionRegistry();
            }
            return global;
        }
    }

    public synchronized BackgroundAction getCurrent() {
        Iterator<BackgroundAction> iter = this.running.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    @Override
    public synchronized void start(BackgroundAction action) {
        this.running.add(action);
    }

    @Override
    public synchronized void stop(BackgroundAction action) {
        this.remove(action);
    }

    @Override
    public synchronized void cancel(BackgroundAction action) {
        if (action.isRunning()) {
            log.debug((Object)String.format("Skip removing action %s currently running", action));
        } else {
            this.remove(action);
        }
    }

    @Override
    public synchronized boolean add(BackgroundAction action) {
        action.addListener(this);
        return super.add(action);
    }

    @Override
    public synchronized boolean remove(Object action) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Remove action %s", action));
        }
        this.running.remove(action);
        if (super.remove(action)) {
            ((BackgroundAction)action).removeListener(this);
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackgroundActionRegistry that = (BackgroundActionRegistry)o;
        return Objects.equals(this.identity, that.identity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.identity);
    }
}

