/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.WebUrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;

public class DefaultUrlProvider
implements UrlProvider {
    private final Host host;

    public DefaultUrlProvider(Host host) {
        this.host = host;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.attributes().getLink() != null) {
            list.add(file.attributes().getLink());
        }
        list.add(new DescriptiveUrl(URI.create(String.format("%s%s", new HostUrlProvider().withUsername(false).get(this.host), URIEncoder.encode(file.getAbsolute()))), DescriptiveUrl.Type.provider, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), this.host.getProtocol().getScheme().toString().toUpperCase(Locale.ROOT))));
        list.addAll(new WebUrlProvider(this.host).toUrl(file));
        return list;
    }
}

