/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProfileDictionary {
    private static final Logger log = Logger.getLogger(ProfileDictionary.class);
    private final DeserializerFactory deserializer;
    private final ProtocolFactory protocols;

    public ProfileDictionary() {
        this(ProtocolFactory.get());
    }

    public ProfileDictionary(ProtocolFactory protocols) {
        this(protocols, new DeserializerFactory());
    }

    public ProfileDictionary(DeserializerFactory deserializer) {
        this(ProtocolFactory.get(), deserializer);
    }

    public ProfileDictionary(ProtocolFactory protocols, DeserializerFactory deserializer) {
        this.protocols = protocols;
        this.deserializer = deserializer;
    }

    public Profile deserialize(Object serialized) {
        Deserializer dict = this.deserializer.create(serialized);
        String protocol = dict.stringForKey("Protocol");
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            Protocol parent = this.protocols.forName(this.protocols.find(new Predicate<Protocol>(){

                @Override
                public boolean test(Protocol protocol) {
                    return !protocol.isEnabled() && !protocol.isBundled();
                }
            }), protocol, null);
            if (null == parent) {
                log.error((Object)String.format("Unknown protocol %s in profile", protocol));
                return null;
            }
            return new Profile(parent, dict);
        }
        log.error((Object)"Missing protocol in profile");
        return null;
    }
}

