/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.log4j.Logger;

public abstract class SegmentingOutputStream
extends ProxyOutputStream {
    private static final Logger log = Logger.getLogger(SegmentingOutputStream.class);
    private final Long threshold;
    private Long written = 0L;
    private final AtomicBoolean after = new AtomicBoolean();
    private final AtomicBoolean close = new AtomicBoolean();
    private final OutputStream buffer;
    private final OutputStream proxy;

    public SegmentingOutputStream(OutputStream proxy, Long threshold, OutputStream buffer) {
        super(proxy);
        this.buffer = buffer;
        this.proxy = proxy;
        this.threshold = -1L == threshold ? Long.MAX_VALUE : threshold;
    }

    public void write(int b) throws IOException {
        this.checkThreshold(1);
        this.buffer.write(b);
        Long l = this.written;
        Long l2 = this.written = Long.valueOf(this.written + 1L);
        this.afterWrite(1);
    }

    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
        this.written = this.written + (long)b.length;
        this.checkThreshold(b.length);
        this.afterWrite(b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.written = this.written + (long)len;
        this.checkThreshold(len);
        this.afterWrite(len);
    }

    protected void afterWrite(int n) {
        this.after.set(true);
    }

    protected void checkThreshold(int count) throws IOException {
        if (this.written >= this.threshold) {
            this.reset();
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.proxy.flush();
    }

    public void close() throws IOException {
        if (this.close.get()) {
            log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
            return;
        }
        try {
            if (this.written > 0L || !this.after.get()) {
                this.reset();
                this.flush();
            }
            this.proxy.close();
        }
        finally {
            this.close.set(true);
        }
    }

    protected void reset() {
        this.written = 0L;
    }
}

