/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class DefaultHostPasswordStore
implements HostPasswordStore {
    private static final Logger log = Logger.getLogger(DefaultHostPasswordStore.class);
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public String findLoginPassword(Host bookmark) {
        String password;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching login password from keychain for %s", bookmark));
        }
        if (null == (password = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername())) && log.isInfoEnabled()) {
            log.info((Object)String.format("Password not found in keychain for %s", bookmark));
        }
        return password;
    }

    @Override
    public String findLoginToken(Host bookmark) {
        String token;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching login token from keychain for %s", bookmark));
        }
        if (null == (token = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), bookmark.getProtocol().getTokenPlaceholder())) && log.isInfoEnabled()) {
            log.info((Object)String.format("Token not found in keychain for %s", bookmark));
        }
        return token;
    }

    @Override
    public String findPrivateKeyPassphrase(Host bookmark) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching private key passphrase from keychain for %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            Local key = credentials.getIdentity();
            String passphrase = this.getPassword(bookmark.getHostname(), key.getAbbreviatedPath());
            if (null == passphrase) {
                passphrase = this.getPassword("SSH", key.getAbsolute());
            }
            if (null == passphrase) {
                passphrase = this.getPassword("SSHKeychain", key.getAbbreviatedPath());
            }
            if (null == passphrase && log.isInfoEnabled()) {
                log.info((Object)String.format("Passphrase not found in keychain for %s", key));
            }
            return passphrase;
        }
        return null;
    }

    @Override
    public OAuthTokens findOAuthTokens(Host bookmark) {
        long expiry = this.preferences.getLong(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()));
        String prefix = this.getOAuthPrefix(bookmark);
        String hostname = this.getOAuthHostname(bookmark);
        return new OAuthTokens(this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), hostname, String.format("%s OAuth2 Access Token", prefix)), this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), hostname, String.format("%s OAuth2 Refresh Token", prefix)), expiry);
    }

    protected String getOAuthHostname(Host bookmark) {
        if (StringUtils.isNotBlank((CharSequence)URI.create(bookmark.getProtocol().getOAuthTokenUrl()).getHost())) {
            return URI.create(bookmark.getProtocol().getOAuthTokenUrl()).getHost();
        }
        return bookmark.getHostname();
    }

    private String getOAuthPrefix(Host bookmark) {
        if (StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
            return String.format("%s (%s)", bookmark.getProtocol().getDescription(), bookmark.getCredentials().getUsername());
        }
        return bookmark.getProtocol().getDescription();
    }

    @Override
    public void save(Host bookmark) throws LocalAccessDeniedException {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        Credentials credentials = bookmark.getCredentials();
        if (!credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip writing credentials for bookmark %s", bookmark.getHostname()));
            }
            return;
        }
        if (credentials.isAnonymousLogin()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Do not write anonymous credentials for bookmark %s", bookmark.getHostname()));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Add password for bookmark %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getIdentityPassphrase());
        }
        if (credentials.isPasswordAuthentication()) {
            if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
                log.warn((Object)String.format("No username in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)credentials.getPassword())) {
                log.warn((Object)String.format("No password in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
        if (credentials.isTokenAuthentication()) {
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), bookmark.getProtocol().getTokenPlaceholder(), credentials.getToken());
        }
        if (credentials.isOAuthAuthentication()) {
            String prefix = this.getOAuthPrefix(bookmark);
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getAccessToken())) {
                this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Access Token", prefix), credentials.getOauth().getAccessToken());
            }
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getRefreshToken())) {
                this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Refresh Token", prefix), credentials.getOauth().getRefreshToken());
            }
            if (credentials.getOauth().getExpiryInMilliseconds() != null) {
                this.preferences.setProperty(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()), credentials.getOauth().getExpiryInMilliseconds());
            }
        }
    }
}

