/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.model.Prop;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Response;
import java.util.List;

public class DavQuota {
    private final long quotaAvailableBytes;
    private final long quotaUsedBytes;

    public DavQuota(Response response) {
        this.quotaAvailableBytes = this.getAvailable(response);
        this.quotaUsedBytes = this.getUsed(response);
    }

    private long getAvailable(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Long.MAX_VALUE;
        }
        for (Propstat propstat : list) {
            Prop prop = propstat.getProp();
            if (null == prop || null == prop.getQuotaAvailableBytes() || prop.getQuotaAvailableBytes().getContent().isEmpty()) continue;
            return Long.valueOf(prop.getQuotaAvailableBytes().getContent().get(0));
        }
        return Long.MAX_VALUE;
    }

    private long getUsed(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return 0L;
        }
        for (Propstat propstat : list) {
            Prop prop = propstat.getProp();
            if (null == prop || null == prop.getQuotaUsedBytes() || prop.getQuotaUsedBytes().getContent().isEmpty()) continue;
            return Long.valueOf(prop.getQuotaUsedBytes().getContent().get(0));
        }
        return 0L;
    }

    public long getQuotaAvailableBytes() {
        return this.quotaAvailableBytes;
    }

    public long getQuotaUsedBytes() {
        return this.quotaUsedBytes;
    }
}

