/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSReadFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.triplecrypt.CryptoExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.CryptoInputStream;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.CryptoUtils;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class CryptoReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(CryptoReadFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSReadFeature proxy;

    public CryptoReadFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSReadFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            FileKey key = new NodesApi((ApiClient)this.session.getClient()).getUserFileKey(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), "");
            UserPrivateKey privateKey = new UserPrivateKey();
            UserKeyPairContainer keyPairContainer = this.session.keyPair();
            privateKey.setPrivateKey(keyPairContainer.getPrivateKeyContainer().getPrivateKey());
            privateKey.setVersion(keyPairContainer.getPrivateKeyContainer().getVersion());
            UserKeyPair userKeyPair = new UserKeyPair();
            userKeyPair.setUserPrivateKey(privateKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt to unlock private key %s", privateKey));
            }
            Credentials passphrase = new TripleCryptKeyPair().unlock((PasswordCallback)callback, this.session.getHost(), userKeyPair);
            PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)TripleCryptConverter.toCryptoEncryptedFileKey(key), (UserPrivateKey)privateKey, (String)passphrase.getPassword());
            return new CryptoInputStream(this.proxy.read(file, status, callback), Crypto.createFileDecryptionCipher((PlainFileKey)plainFileKey), CryptoUtils.stringToByteArray((String)plainFileKey.getTag()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (CryptoException e) {
            throw new CryptoExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    public boolean offset(Path file) {
        return false;
    }
}

