/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

public class OAuthAuthorization {
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="expiresAt")
    private DateTime expiresAt = null;

    public OAuthAuthorization clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthAuthorization clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public OAuthAuthorization expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Expiration date of the authorization")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthAuthorization oauthAuthorization = (OAuthAuthorization)o;
        return Objects.equals(this.clientId, oauthAuthorization.clientId) && Objects.equals(this.clientName, oauthAuthorization.clientName) && Objects.equals(this.expiresAt, oauthAuthorization.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientName, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthAuthorization {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

