/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

public class Customer {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="quotaUsed")
    private Long quotaUsed = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="userUsed")
    private Integer userUsed = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="trialDaysLeft")
    private Integer trialDaysLeft = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="lastLoginAt")
    private DateTime lastLoginAt = null;
    @JsonProperty(value="customerAttributes")
    private CustomerAttributes customerAttributes = null;
    @JsonProperty(value="activationCode")
    private String activationCode = null;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;

    public Customer id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the customer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Customer companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(required=true, value="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Customer customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @ApiModelProperty(example="pay", required=true, value="Customer type")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public Customer quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal disc space which can be allocated by customer in bytes.")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public Customer quotaUsed(Long quotaUsed) {
        this.quotaUsed = quotaUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Used amount of disc space in bytes")
    public Long getQuotaUsed() {
        return this.quotaUsed;
    }

    public void setQuotaUsed(Long quotaUsed) {
        this.quotaUsed = quotaUsed;
    }

    public Customer userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public Customer userUsed(Integer userUsed) {
        this.userUsed = userUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of users which are already allocated.")
    public Integer getUserUsed() {
        return this.userUsed;
    }

    public void setUserUsed(Integer userUsed) {
        this.userUsed = userUsed;
    }

    public Customer lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="DEPRECATED. Please use isLocked. Customer lock status: * `false` - unlocked * `true` - locked  All users of this customer will be blocked and can not login anymore. (default: false)")
    public Boolean getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public Customer isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", value="Customer is locked: * `false` - unlocked * `true` - locked  All users of this customer will be blocked and can not login anymore. (default: false)")
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public Customer createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", required=true, value="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Customer trialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
        return this;
    }

    @ApiModelProperty(value="Number of days left for trial period (relevant only for type `demo`)")
    public Integer getTrialDaysLeft() {
        return this.trialDaysLeft;
    }

    public void setTrialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
    }

    public Customer updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Customer lastLoginAt(DateTime lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Date of last seen login for the customer")
    public DateTime getLastLoginAt() {
        return this.lastLoginAt;
    }

    public void setLastLoginAt(DateTime lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    public Customer customerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
        return this;
    }

    @ApiModelProperty(value="Customer attributes")
    public CustomerAttributes getCustomerAttributes() {
        return this.customerAttributes;
    }

    public void setCustomerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    public Customer activationCode(String activationCode) {
        this.activationCode = activationCode;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Customer activation code string: * valid only for types `free` and `demo` * for `pay` customers it is empty")
    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public Customer providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Provider customer ID")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.id, customer.id) && Objects.equals(this.companyName, customer.companyName) && Objects.equals((Object)this.customerContractType, (Object)customer.customerContractType) && Objects.equals(this.quotaMax, customer.quotaMax) && Objects.equals(this.quotaUsed, customer.quotaUsed) && Objects.equals(this.userMax, customer.userMax) && Objects.equals(this.userUsed, customer.userUsed) && Objects.equals(this.lockStatus, customer.lockStatus) && Objects.equals(this.isLocked, customer.isLocked) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.trialDaysLeft, customer.trialDaysLeft) && Objects.equals(this.updatedAt, customer.updatedAt) && Objects.equals(this.lastLoginAt, customer.lastLoginAt) && Objects.equals(this.customerAttributes, customer.customerAttributes) && Objects.equals(this.activationCode, customer.activationCode) && Objects.equals(this.providerCustomerId, customer.providerCustomerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.companyName, this.customerContractType, this.quotaMax, this.quotaUsed, this.userMax, this.userUsed, this.lockStatus, this.isLocked, this.createdAt, this.trialDaysLeft, this.updatedAt, this.lastLoginAt, this.customerAttributes, this.activationCode, this.providerCustomerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Customer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    quotaUsed: ").append(this.toIndentedString(this.quotaUsed)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    userUsed: ").append(this.toIndentedString(this.userUsed)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    trialDaysLeft: ").append(this.toIndentedString(this.trialDaysLeft)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    lastLoginAt: ").append(this.toIndentedString(this.lastLoginAt)).append("\n");
        sb.append("    customerAttributes: ").append(this.toIndentedString(this.customerAttributes)).append("\n");
        sb.append("    activationCode: ").append(this.toIndentedString(this.activationCode)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        FREE("free"),
        DEMO("demo"),
        PAY("pay");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

