/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import java.util.EnumSet;

public class SDSSearchFeature
implements Search {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSSearchFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList result = new AttributedList();
            NodeList list = new NodesApi((ApiClient)this.session.getClient()).searchFsNodes(String.format("*%s*", regex.toPattern().pattern()), -1, Long.valueOf(this.nodeid.getFileid(workdir, listener)), null, null, null, null, "", null);
            SDSAttributesFinderFeature feature = new SDSAttributesFinderFeature(this.session, this.nodeid);
            for (Node node : list.getItems()) {
                EnumSet<AbstractPath.Type> type;
                PathAttributes attributes = feature.toAttributes(node);
                switch (node.getType()) {
                    case ROOM: {
                        type = EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume);
                        break;
                    }
                    case FOLDER: {
                        type = EnumSet.of(AbstractPath.Type.directory);
                        break;
                    }
                    default: {
                        type = EnumSet.of(AbstractPath.Type.file);
                    }
                }
                result.add((Referenceable)new Path(String.format("%s%s", node.getParentPath(), node.getName()), type, attributes));
            }
            return result;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, workdir);
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

