/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;

public class SDSHomeFinderService
extends DefaultHomeFinderService {
    private final SDSSession session;

    public SDSHomeFinderService(SDSSession session) {
        super((Session)session);
        this.session = session;
    }

    public Path find() throws BackgroundException {
        Path path = super.find();
        if (path.isRoot()) {
            Acl acl = new Acl();
            if (this.session.userAccount().isUserInRole(SDSPermissionsFeature.ROOM_MANAGER_ROLE)) {
                Acl.CanonicalUser user = new Acl.CanonicalUser();
                acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
            }
            path.attributes().setAcl(acl);
        } else {
            Acl acl = new SDSPermissionsFeature(this.session, new SDSNodeIdProvider(this.session)).getPermission(path);
            path.attributes().setAcl(acl);
        }
        return path;
    }
}

