/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.utils.ServiceUtils;

public class GoogleStorageBucketCreateService {
    private final GoogleStorageSession session;

    public GoogleStorageBucketCreateService(GoogleStorageSession session) {
        this.session = session;
    }

    public void create(Path bucket, String location) throws BackgroundException {
        if (!ServiceUtils.isBucketNameValidDNSName((String)bucket.getName())) {
            throw new InteroperabilityException(LocaleFactory.localizedString((String)"Bucket name is not DNS compatible", (String)"S3"));
        }
        GSAccessControlList acl = PreferencesFactory.get().getProperty("s3.bucket.acl.default").equals("public-read") ? GSAccessControlList.REST_CANNED_PUBLIC_READ : GSAccessControlList.REST_CANNED_PRIVATE;
        try {
            ((RequestEntityRestStorageService)this.session.getClient()).createBucket(new S3PathContainerService().getContainer(bucket).getName(), location, (AccessControlList)acl);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, bucket);
        }
    }
}

