/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.facets.Facet;

public class OneDrivePatchOperation {
    private final JsonObject jsonObject = new JsonObject();

    public void rename(String newName) {
        this.jsonObject.add("name", newName);
    }

    public void move(OneDriveFolder newParent) {
        JsonObject parentReference = new JsonObject();
        OneDriveDrive rootDrive = newParent.getDrive();
        if (null != rootDrive) {
            parentReference.add("driveId", newParent.getDrive().getItemIdentifier());
            parentReference.add("id", newParent.getItemIdentifier());
        } else if (OneDriveItem.ItemIdentifierType.Path == newParent.getItemIdentifierType()) {
            parentReference.add("path", newParent.getFullyQualifiedPath());
        }
        this.jsonObject.add("parentReference", (JsonValue)parentReference);
    }

    public void facet(String property, Facet facet) {
        this.jsonObject.add(property, (JsonValue)facet.toJson());
    }

    JsonObject build() {
        return this.jsonObject;
    }
}

