/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.nuxeo.onedrive.client.AbstractRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.RequestExecutor;

public class OneDriveJsonRequest
extends AbstractRequest<OneDriveJsonResponse> {
    private JsonObject body;

    public OneDriveJsonRequest(URL url, String method) {
        super(url, method);
    }

    public OneDriveJsonRequest(URL url, String method, JsonObject body) {
        super(url, method);
        this.body = body;
        this.addHeader("Content-Type", "application/json");
        this.addHeader("Accept", "application/json");
    }

    @Override
    public OneDriveJsonResponse sendRequest(RequestExecutor sender) throws IOException {
        if (this.body != null) {
            byte[] bytes = this.body.toString().getBytes(StandardCharsets.UTF_8);
            return (OneDriveJsonResponse)this.sendRequest(sender, new ByteArrayInputStream(bytes));
        }
        return (OneDriveJsonResponse)super.sendRequest(sender);
    }

    @Override
    protected OneDriveJsonResponse createResponse(RequestExecutor.Response response) throws IOException {
        return new OneDriveJsonResponse(response.getStatusCode(), response.getStatusMessage(), response.getLocation(), response.getInputStream());
    }
}

