/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.resources.GroupItem;

public class GroupsIterator
implements Iterator<GroupItem.Metadata> {
    private static final URLTemplate GROUP_LIST_URL = new URLTemplate("/groups");
    private final OneDriveAPI api;
    private final JsonObjectIterator jsonObjectIterator;

    public GroupsIterator(OneDriveAPI api) {
        this.api = Objects.requireNonNull(api);
        this.jsonObjectIterator = new JsonObjectIterator(api, GROUP_LIST_URL.build(api.getBaseURL()));
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public GroupItem.Metadata next() {
        GroupItem groupItem;
        JsonObject jsonObject = this.jsonObjectIterator.next();
        String id = jsonObject.get("id").asString();
        GroupItem groupItem2 = groupItem = new GroupItem(this.api, id);
        groupItem2.getClass();
        return groupItem2.new GroupItem.Metadata(jsonObject);
    }
}

