/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.dav.ContentLengthStatusInputStream;
import ch.cyberduck.core.dav.SaxPropFindResponseHandler;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineImpl;
import com.github.sardine.impl.handler.VoidResponseHandler;
import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.Propfind;
import com.github.sardine.model.Response;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class DAVClient
extends SardineImpl {
    private static final Logger log = Logger.getLogger(DAVClient.class);
    private final String uri;

    public DAVClient(String uri, HttpClientBuilder http) {
        super(http);
        this.uri = uri;
    }

    public <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)request.getURI().getRawQuery())) {
            request.setURI(URI.create(String.format("%s%s?%s", this.uri, request.getURI().getRawPath(), request.getURI().getRawQuery())));
        } else {
            request.setURI(URI.create(String.format("%s%s", this.uri, request.getURI().getRawPath())));
        }
        return (T)super.execute(request, responseHandler);
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)request.getURI().getRawQuery())) {
            request.setURI(URI.create(String.format("%s%s?%s", this.uri, request.getURI().getRawPath(), request.getURI().getRawQuery())));
        } else {
            request.setURI(URI.create(String.format("%s%s", this.uri, request.getURI().getRawPath())));
        }
        return super.execute(request);
    }

    protected List<DavResource> propfind(String url, int depth, Propfind body) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth(depth < 0 ? "infinity" : Integer.toString(depth));
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml((Object)body), StandardCharsets.UTF_8));
        Multistatus multistatus = (Multistatus)this.execute((HttpRequestBase)entity, (ResponseHandler)new SaxPropFindResponseHandler());
        List responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn((Object)String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    public ContentLengthStatusInputStream get(String url, List<Header> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        for (Header header : headers) {
            get.addHeader(header);
        }
        HttpResponse response = this.execute((HttpRequestBase)get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            handler.handleResponse(response);
            return new ContentLengthStatusInputStream((InputStream)new HttpMethodReleaseInputStream(response), response.getEntity().getContentLength(), response.getStatusLine().getStatusCode());
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }

    public HttpClientContext context() {
        return this.context;
    }
}

