/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature;

import com.joyent.http.signature.crypto.NssBridgeKeyConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;

public final class KeyPairLoader {
    private static final NssBridgeKeyConverter CONVERTER = new NssBridgeKeyConverter();

    private KeyPairLoader() {
        CONVERTER.setProvider("BC");
    }

    public static KeyPair getKeyPair(File keyFile) throws IOException {
        return KeyPairLoader.getKeyPair(keyFile.toPath(), null);
    }

    public static KeyPair getKeyPair(File keyFile, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(keyFile.toPath(), password);
    }

    public static KeyPair getKeyPair(Path keyPath) throws IOException {
        return KeyPairLoader.getKeyPair(keyPath, null);
    }

    public static KeyPair getKeyPair(Path keyPath, char[] password) throws IOException {
        if (keyPath == null) {
            throw new FileNotFoundException("No key file path specified");
        }
        if (!Files.exists(keyPath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("No key file available at path: %s", keyPath));
        }
        if (!Files.isReadable(keyPath)) {
            throw new IOException(String.format("Can't read key file from path: %s", keyPath));
        }
        try (InputStream is = Files.newInputStream(keyPath, new OpenOption[0]);){
            KeyPair keyPair = KeyPairLoader.getKeyPair(is, password);
            return keyPair;
        }
    }

    public static KeyPair getKeyPair(String privateKeyContent, char[] password) throws IOException {
        byte[] pKeyBytes = privateKeyContent.getBytes(StandardCharsets.US_ASCII);
        return KeyPairLoader.getKeyPair(pKeyBytes, password);
    }

    public static KeyPair getKeyPair(byte[] pKeyBytes, char[] password) throws IOException {
        if (pKeyBytes == null) {
            throw new IllegalArgumentException("pKeyBytes must be present");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(pKeyBytes);){
            KeyPair keyPair = KeyPairLoader.getKeyPair(is, password);
            return keyPair;
        }
    }

    /*
     * Exception decompiling
     */
    public static KeyPair getKeyPair(InputStream is, char[] password) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

