/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.uploader;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlGenerator {
    public static final String xmlVersionNumber = "1.0";
    private List objectRequestList = new ArrayList();
    private Map applicationProperties = new HashMap();
    private Map messageProperties = new HashMap();

    public void addSignatureRequest(String key, String bucketName, Map metadata, SignatureRequest signatureRequest) {
        this.objectRequestList.add(new ObjectAndSignatureRequestDetails(key, bucketName, metadata, signatureRequest));
    }

    public void addApplicationProperties(Map properties) {
        this.applicationProperties.putAll(properties);
    }

    public void addMessageProperties(Map properties) {
        this.messageProperties.putAll(properties);
    }

    public String generateXml() throws Exception {
        String propertyValue;
        String propertyName;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElem = document.createElement("Uploader");
        document.appendChild(rootElem);
        rootElem.setAttribute("version", xmlVersionNumber);
        rootElem.setAttribute("uploadDate", ServiceUtils.formatIso8601Date(new Date()));
        for (Map.Entry entry : this.applicationProperties.entrySet()) {
            propertyName = (String)entry.getKey();
            propertyValue = (String)entry.getValue();
            rootElem.appendChild(this.createPropertyElement(document, propertyName, propertyValue, "ApplicationProperty"));
        }
        for (Map.Entry entry : this.messageProperties.entrySet()) {
            propertyName = (String)entry.getKey();
            propertyValue = (String)entry.getValue();
            rootElem.appendChild(this.createPropertyElement(document, propertyName, propertyValue, "MessageProperty"));
        }
        ObjectAndSignatureRequestDetails[] details = this.objectRequestList.toArray(new ObjectAndSignatureRequestDetails[this.objectRequestList.size()]);
        for (int i = 0; i < details.length; ++i) {
            ObjectAndSignatureRequestDetails objectDetails = details[i];
            rootElem.appendChild(this.createSignatureRequestElement(document, objectDetails));
        }
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.transform(domSource, streamResult);
        return writer.toString();
    }

    private Element createPropertyElement(Document document, String propertyName, String propertyValue, String source) {
        Element propertyElem = document.createElement(source);
        if (propertyName != null) {
            propertyElem.setAttribute("name", propertyName);
        }
        if (propertyValue != null) {
            CDATASection cdataSection = document.createCDATASection(propertyValue);
            propertyElem.appendChild(cdataSection);
        }
        return propertyElem;
    }

    private Element createSignatureRequestElement(Document document, ObjectAndSignatureRequestDetails details) {
        SignatureRequest request = details.signatureRequest;
        Element requestElem = document.createElement("SignatureRequest");
        requestElem.setAttribute("type", request.getSignatureType());
        requestElem.setAttribute("signed", String.valueOf(request.isSigned()));
        requestElem.appendChild(this.createObjectElement(document, details.key, details.bucketName, details.metadata, "RequestObject"));
        if (request.isSigned()) {
            requestElem.appendChild(this.createObjectElement(document, request.getObjectKey(), request.getBucketName(), request.getObjectMetadata(), "SignedObject"));
            requestElem.appendChild(this.createPropertyElement(document, null, request.getSignedUrl(), "SignedURL"));
        } else if (request.getDeclineReason() != null) {
            requestElem.appendChild(this.createPropertyElement(document, null, request.getDeclineReason(), "DeclineReason"));
        }
        return requestElem;
    }

    private Element createObjectElement(Document document, String key, String bucketName, Map metadata, String elementName) {
        if (key == null) {
            key = "";
        }
        if (bucketName == null) {
            bucketName = "";
        }
        Element objectElement = document.createElement(elementName);
        objectElement.setAttribute("key", key);
        objectElement.setAttribute("bucketName", bucketName);
        for (Map.Entry entry : metadata.entrySet()) {
            String metadataName = (String)entry.getKey();
            String metadataValue = (String)entry.getValue();
            if (metadataValue == null) {
                metadataValue = "";
            }
            objectElement.appendChild(this.createPropertyElement(document, metadataName, metadataValue, "Metadata"));
        }
        return objectElement;
    }

    private class ObjectAndSignatureRequestDetails {
        public String key = null;
        public String bucketName = null;
        public Map metadata = null;
        public SignatureRequest signatureRequest = null;

        public ObjectAndSignatureRequestDetails(String key, String bucketName, Map metadata, SignatureRequest signatureRequest) {
            this.key = key;
            this.bucketName = bucketName;
            this.metadata = metadata;
            this.signatureRequest = signatureRequest;
        }
    }
}

