/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.AllocateJobChunkRequest;
import com.spectralogic.ds3client.commands.AllocateJobChunkResponse;
import com.spectralogic.ds3client.commands.PutObjectRequest;
import com.spectralogic.ds3client.exceptions.Ds3NoMoreRetriesException;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.ChunkTransferrer;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobImpl;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.JobPartTrackerFactory;
import com.spectralogic.ds3client.helpers.JobState;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.models.Range;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import com.spectralogic.ds3client.models.bulk.Objects;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.SeekableByteChannelInputStream;
import com.spectralogic.ds3client.utils.hashing.CRC32CHasher;
import com.spectralogic.ds3client.utils.hashing.CRC32Hasher;
import com.spectralogic.ds3client.utils.hashing.Hasher;
import com.spectralogic.ds3client.utils.hashing.MD5Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA256Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA512Hasher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteJobImpl
extends JobImpl {
    private static final Logger LOG = LoggerFactory.getLogger(WriteJobImpl.class);
    private final JobPartTracker partTracker;
    private final List<Objects> filteredChunks;
    private final int retryAfter;
    private final Checksum.Type checksumType;
    private final Map<ChecksumListener, ChecksumListener> checksumListeners;
    private int retryAfterLeft;
    private Ds3ClientHelpers.MetadataAccess metadataAccess = null;
    private ChecksumFunction checksumFunction = null;

    public WriteJobImpl(Ds3Client client, MasterObjectList masterObjectList, int retryAfter, Checksum.Type type) {
        super(client, masterObjectList);
        if (this.masterObjectList == null || this.masterObjectList.getObjects() == null) {
            LOG.info("Job has no data to transfer");
            this.filteredChunks = null;
            this.partTracker = null;
        } else {
            LOG.info("Ready to start transfer for job " + masterObjectList.getJobId().toString() + " with " + masterObjectList.getObjects().size() + " chunks");
            this.filteredChunks = WriteJobImpl.filterChunks(this.masterObjectList.getObjects());
            this.partTracker = JobPartTrackerFactory.buildPartTracker(Iterables.concat(this.filteredChunks));
        }
        this.retryAfter = this.retryAfterLeft = retryAfter;
        this.checksumListeners = new IdentityHashMap<ChecksumListener, ChecksumListener>();
        this.checksumType = type;
    }

    @Override
    public void attachDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.partTracker.attachDataTransferredListener(listener);
    }

    @Override
    public void attachObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.partTracker.attachObjectCompletedListener(listener);
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.partTracker.removeDataTransferredListener(listener);
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.partTracker.removeObjectCompletedListener(listener);
    }

    @Override
    public void attachMetadataReceivedListener(MetadataReceivedListener listener) {
        throw new IllegalStateException("Metadata listeners are not used with Write jobs");
    }

    @Override
    public void removeMetadataReceivedListener(MetadataReceivedListener listener) {
        throw new IllegalStateException("Metadata listeners are not used with Write jobs");
    }

    @Override
    public void attachChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.checksumListeners.put(listener, listener);
    }

    @Override
    public void removeChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.checksumListeners.remove(listener);
    }

    @Override
    public Ds3ClientHelpers.Job withMetadata(Ds3ClientHelpers.MetadataAccess access) {
        this.checkRunning();
        this.metadataAccess = access;
        return this;
    }

    @Override
    public Ds3ClientHelpers.Job withChecksum(ChecksumFunction checksumFunction) {
        this.checksumFunction = checksumFunction;
        return this;
    }

    @Override
    public void transfer(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) throws SignatureException, IOException, XmlProcessingException {
        this.running = true;
        LOG.debug("Starting job transfer");
        if (this.masterObjectList == null || this.masterObjectList.getObjects() == null) {
            LOG.info("There is nothing to transfer for job" + (this.getJobId() == null ? "" : " " + this.getJobId().toString()));
            return;
        }
        try (JobState jobState = new JobState(channelBuilder, this.filteredChunks, this.partTracker, (ImmutableMap<String, ImmutableMultimap<BulkObject, Range>>)ImmutableMap.of());){
            ChunkTransferrer chunkTransferrer = new ChunkTransferrer(new PutObjectTransferrer(jobState), this.client, jobState.getPartTracker(), this.maxParallelRequests);
            for (Objects chunk : this.filteredChunks) {
                LOG.debug("Allocating chunk: " + chunk.getChunkId().toString());
                chunkTransferrer.transferChunks(this.masterObjectList.getNodes(), Collections.singletonList(WriteJobImpl.filterChunk(this.allocateChunk(chunk))));
            }
        }
        catch (XmlProcessingException | IOException | RuntimeException | SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Objects allocateChunk(Objects filtered) throws IOException, SignatureException {
        Objects chunk = null;
        while (chunk == null) {
            chunk = this.tryAllocateChunk(filtered);
        }
        return chunk;
    }

    private Objects tryAllocateChunk(Objects filtered) throws IOException, SignatureException {
        AllocateJobChunkResponse response = this.client.allocateJobChunk(new AllocateJobChunkRequest(filtered.getChunkId()));
        LOG.info("AllocatedJobChunkResponse status: " + response.getStatus().toString());
        switch (response.getStatus()) {
            case ALLOCATED: {
                this.retryAfterLeft = this.retryAfter;
                return response.getObjects();
            }
            case RETRYLATER: {
                try {
                    if (this.retryAfterLeft == 0) {
                        throw new Ds3NoMoreRetriesException(this.retryAfter);
                    }
                    --this.retryAfterLeft;
                    int retryAfter = response.getRetryAfterSeconds() * 1000;
                    LOG.debug("Will retry allocate chunk call after " + retryAfter + " seconds");
                    Thread.sleep(retryAfter);
                    return null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        assert (false) : "This line of code should be impossible to hit.";
        return null;
    }

    private static List<Objects> filterChunks(List<Objects> chunks) {
        ArrayList<Objects> filteredChunks = new ArrayList<Objects>();
        for (Objects chunk : chunks) {
            Objects filteredChunk = WriteJobImpl.filterChunk(chunk);
            if (filteredChunk.getObjects().size() <= 0) continue;
            filteredChunks.add(filteredChunk);
        }
        return filteredChunks;
    }

    private static Objects filterChunk(Objects chunk) {
        Objects newChunk = new Objects();
        newChunk.setChunkId(chunk.getChunkId());
        newChunk.setChunkNumber(chunk.getChunkNumber());
        newChunk.setNodeId(chunk.getNodeId());
        newChunk.setObjects(WriteJobImpl.filterObjects(chunk.getObjects()));
        return newChunk;
    }

    private static List<BulkObject> filterObjects(List<BulkObject> list) {
        ArrayList<BulkObject> filtered = new ArrayList<BulkObject>();
        for (BulkObject obj : list) {
            if (obj.isInCache()) continue;
            filtered.add(obj);
        }
        return filtered;
    }

    private void emitChecksumEvents(BulkObject bulkObject, Checksum.Type type, String checksum) {
        for (ChecksumListener listener : this.checksumListeners.values()) {
            listener.value(bulkObject, type, checksum);
        }
    }

    private final class PutObjectTransferrer
    implements ChunkTransferrer.ItemTransferrer {
        private final JobState jobState;
        private static final int READ_BUFFER_SIZE = 0xA00000;

        private PutObjectTransferrer(JobState jobState) {
            this.jobState = jobState;
        }

        @Override
        public void transferItem(Ds3Client client, BulkObject ds3Object) throws SignatureException, IOException {
            client.putObject(this.createRequest(ds3Object));
        }

        private PutObjectRequest createRequest(BulkObject ds3Object) throws IOException {
            String checksum;
            SeekableByteChannel channel = this.jobState.getChannel(ds3Object.getName(), ds3Object.getOffset(), ds3Object.getLength());
            PutObjectRequest request = new PutObjectRequest(WriteJobImpl.this.masterObjectList.getBucketName(), ds3Object.getName(), WriteJobImpl.this.getJobId(), ds3Object.getLength(), ds3Object.getOffset(), channel);
            if (ds3Object.getOffset() == 0L && WriteJobImpl.this.metadataAccess != null) {
                Map<String, String> metadata = WriteJobImpl.this.metadataAccess.getMetadataValue(ds3Object.getName());
                if (Guard.isMapNullOrEmpty(metadata)) {
                    return request;
                }
                ImmutableMap immutableMetadata = ImmutableMap.copyOf(metadata);
                for (Map.Entry value : immutableMetadata.entrySet()) {
                    request.withMetaData((String)value.getKey(), (String)value.getValue());
                }
            }
            if ((checksum = this.calculateChecksum(ds3Object, channel)) != null) {
                request.withChecksum(Checksum.value(checksum), WriteJobImpl.this.checksumType);
                WriteJobImpl.this.emitChecksumEvents(ds3Object, WriteJobImpl.this.checksumType, checksum);
            }
            return request;
        }

        private String calculateChecksum(BulkObject ds3Object, SeekableByteChannel channel) throws IOException {
            if (WriteJobImpl.this.checksumType != Checksum.Type.NONE) {
                if (WriteJobImpl.this.checksumFunction == null) {
                    LOG.info("Calculating " + WriteJobImpl.this.checksumType.toString() + " checksum for blob: " + ds3Object.toString());
                    SeekableByteChannelInputStream dataStream = new SeekableByteChannelInputStream(channel);
                    Hasher hasher = this.getHasher(WriteJobImpl.this.checksumType);
                    String checksum = this.hashInputStream(hasher, dataStream);
                    LOG.info("Computed checksum for blob: " + checksum);
                    return checksum;
                }
                LOG.info("Getting checksum from user supplied callback for blob: " + ds3Object.toString());
                String checksum = WriteJobImpl.this.checksumFunction.compute(ds3Object, channel);
                LOG.info("User supplied checksum is: " + checksum);
                return checksum;
            }
            return null;
        }

        private String hashInputStream(Hasher digest, InputStream stream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[0xA00000];
            while ((bytesRead = stream.read(buffer)) >= 0) {
                digest.update(buffer, 0, bytesRead);
            }
            return digest.digest();
        }

        private Hasher getHasher(Checksum.Type checksumType) {
            switch (checksumType) {
                case MD5: {
                    return new MD5Hasher();
                }
                case SHA256: {
                    return new SHA256Hasher();
                }
                case SHA512: {
                    return new SHA512Hasher();
                }
                case CRC32: {
                    return new CRC32Hasher();
                }
                case CRC32C: {
                    return new CRC32CHasher();
                }
            }
            throw new RuntimeException("Unknown checksum type " + checksumType.toString());
        }
    }
}

