/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.models.bulk.Node;
import com.spectralogic.ds3client.models.bulk.Objects;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChunkTransferrer {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkTransferrer.class);
    private final ItemTransferrer itemTransferrer;
    private final Ds3Client mainClient;
    private final JobPartTracker partTracker;
    private final int maxParallelRequests;

    public ChunkTransferrer(ItemTransferrer transferrer, Ds3Client mainClient, JobPartTracker partTracker, int maxParallelRequests) {
        this.itemTransferrer = transferrer;
        this.mainClient = mainClient;
        this.partTracker = partTracker;
        this.maxParallelRequests = maxParallelRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferChunks(Iterable<Node> nodes, Iterable<Objects> chunks) throws SignatureException, IOException, XmlProcessingException {
        LOG.debug("Getting ready to process chunks");
        Map<UUID, Node> nodeMap = ChunkTransferrer.buildNodeMap(nodes);
        LOG.debug("Starting executor service");
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.maxParallelRequests));
        LOG.debug("Executor service started");
        try {
            ArrayList tasks = new ArrayList();
            for (Objects chunk : chunks) {
                LOG.debug("Processing parts for chunk: " + chunk.getChunkId().toString());
                final Ds3Client client = this.mainClient.newForNode(nodeMap.get(chunk.getNodeId()));
                for (final BulkObject ds3Object : chunk) {
                    final ObjectPart part = new ObjectPart(ds3Object.getOffset(), ds3Object.getLength());
                    if (!this.partTracker.containsPart(ds3Object.getName(), part)) continue;
                    LOG.debug("Adding " + ds3Object.getName() + " to executor for processing");
                    tasks.add(executor.submit((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            LOG.debug("Processing " + ds3Object.getName());
                            ChunkTransferrer.this.itemTransferrer.transferItem(client, ds3Object);
                            ChunkTransferrer.this.partTracker.completePart(ds3Object.getName(), part);
                            return null;
                        }
                    }));
                }
            }
            ChunkTransferrer.executeWithExceptionHandling(tasks);
        }
        finally {
            LOG.debug("Shutting down executor");
            executor.shutdown();
        }
    }

    private static Map<UUID, Node> buildNodeMap(Iterable<Node> nodes) {
        HashMap<UUID, Node> nodeMap = new HashMap<UUID, Node>();
        for (Node node : nodes) {
            nodeMap.put(node.getId(), node);
        }
        return nodeMap;
    }

    private static void executeWithExceptionHandling(List<ListenableFuture<?>> tasks) throws IOException, SignatureException, XmlProcessingException {
        try {
            Futures.allAsList(tasks).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SignatureException) {
                throw (SignatureException)cause;
            }
            if (cause instanceof XmlProcessingException) {
                throw (XmlProcessingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static interface ItemTransferrer {
        public void transferItem(Ds3Client var1, BulkObject var2) throws SignatureException, IOException;
    }
}

