/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.notifications;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.models.notification.NotificationRegistration;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class NotificationResponse
extends AbstractResponse {
    private NotificationRegistration registration;

    public NotificationResponse(WebResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();){
            if (response == null) {
                throw new IOException("response was null");
            }
            this.checkStatusCode(200, 201);
            try (InputStream content = response.getResponseStream();){
                this.registration = XmlOutput.fromXml(content, NotificationRegistration.class);
            }
        }
    }

    public NotificationRegistration getRegistration() {
        return this.registration;
    }
}

