/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.models.bulk.JobInfo;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class GetJobsResponse
extends AbstractResponse {
    private List<JobInfo> jobs;

    public GetJobsResponse(WebResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();){
            this.checkStatusCode(200);
            this.jobs = GetJobsResponse.parseJobs(response).getJobs();
        }
    }

    public List<JobInfo> getJobs() {
        return this.jobs;
    }

    private static Jobs parseJobs(WebResponse webResponse) throws IOException {
        try (InputStream content = webResponse.getResponseStream();){
            Jobs jobs = XmlOutput.fromXml(content, Jobs.class);
            return jobs;
        }
    }

    private static class Jobs {
        @JsonProperty(value="Job")
        private List<JobInfo> jobs;

        private Jobs() {
        }

        public List<JobInfo> getJobs() {
            return this.jobs;
        }
    }
}

