/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.commands.RetryAfterExpectedException;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetAvailableJobChunksResponse
extends AbstractResponse {
    private Status status;
    private MasterObjectList masterObjectList;
    private int retryAfterSeconds;

    public Status getStatus() {
        return this.status;
    }

    public MasterObjectList getMasterObjectList() {
        return this.masterObjectList;
    }

    public int getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public GetAvailableJobChunksResponse(WebResponse response) throws IOException {
        super(response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processResponse() throws IOException {
        try (WebResponse webResponse = this.getResponse();){
            this.checkStatusCode(200);
            switch (this.getStatusCode()) {
                case 200: {
                    this.masterObjectList = GetAvailableJobChunksResponse.parseMasterObjectList(webResponse);
                    if (this.masterObjectList.getObjects() == null) {
                        this.status = Status.RETRYLATER;
                        this.retryAfterSeconds = GetAvailableJobChunksResponse.parseRetryAfter(webResponse);
                        return;
                    } else {
                        this.status = Status.AVAILABLE;
                        return;
                    }
                }
                default: {
                    assert (false) : "checkStatusCode should have made it impossible to reach this line.";
                    return;
                }
            }
        }
    }

    private static MasterObjectList parseMasterObjectList(WebResponse webResponse) throws IOException {
        try (InputStream content = webResponse.getResponseStream();){
            MasterObjectList masterObjectList = XmlOutput.fromXml(content, MasterObjectList.class);
            return masterObjectList;
        }
    }

    private static int parseRetryAfter(WebResponse webResponse) {
        String retryAfter = webResponse.getHeaders().get("Retry-After").get(0);
        if (retryAfter == null) {
            throw new RetryAfterExpectedException();
        }
        return Integer.parseInt(retryAfter);
    }

    public static enum Status {
        AVAILABLE,
        RETRYLATER;

    }
}

