/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BulkResponse
extends AbstractResponse {
    private static final Logger LOG = LoggerFactory.getLogger(BulkResponse.class);
    private MasterObjectList result;

    public BulkResponse(WebResponse response) throws IOException {
        super(response);
    }

    public MasterObjectList getResult() {
        return this.result;
    }

    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();){
            this.checkStatusCode(200, 204);
            if (response.getResponseStream() == null) {
                LOG.info("Job has nothing to do, returning empty master object list");
                this.result = null;
                return;
            }
            try (InputStream content = response.getResponseStream();){
                LOG.debug("Starting bulk response parsing");
                this.result = XmlOutput.fromXml(content, MasterObjectList.class);
                LOG.debug("Finished bulk response parsing");
            }
        }
    }
}

