/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.spectralogic.ds3client.commands.Ds3Response;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.models.Error;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.networking.Headers;
import com.spectralogic.ds3client.networking.ResponseProcessingException;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.ResponseUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponse
implements Ds3Response {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResponse.class);
    public static final String UTF8 = "UTF-8";
    private final WebResponse response;
    private final String checksum;
    private final Checksum.Type checksumType;

    public AbstractResponse(WebResponse response) throws IOException {
        this.response = response;
        if (response != null) {
            this.checksumType = AbstractResponse.determineChecksumType(this.response.getHeaders());
            this.checksum = this.checksumType != null ? AbstractResponse.getFirstHeaderValue(this.response.getHeaders(), "content-" + this.checksumType.toString().toLowerCase()) : null;
        } else {
            this.checksum = null;
            this.checksumType = Checksum.Type.NONE;
        }
        this.processResponse();
    }

    private static Checksum.Type determineChecksumType(Headers headers) throws ResponseProcessingException {
        for (Checksum.Type type : Checksum.Type.values()) {
            if (AbstractResponse.getFirstHeaderValue(headers, "content-" + type.toString().toLowerCase()) == null) continue;
            return type;
        }
        LOG.debug("Did not find a content checksum header");
        return null;
    }

    protected static String getFirstHeaderValue(Headers headers, String key) {
        List<String> valueList = headers.get(key);
        if (Guard.isNullOrEmpty(valueList)) {
            return null;
        }
        return valueList.get(0);
    }

    protected static long getSizeFromHeaders(Headers headers) {
        if (headers == null) {
            LOG.debug("Could not get the headers to determine the content-length");
            return -1L;
        }
        List<String> contentLength = headers.get("Content-Length");
        if (Guard.isNullOrEmpty(contentLength) || contentLength.get(0) == null) {
            LOG.debug("Could not find the content-length header to determine the size of the request");
            return -1L;
        }
        return Long.parseLong(contentLength.get(0));
    }

    protected abstract void processResponse() throws IOException;

    public WebResponse getResponse() {
        return this.response;
    }

    public void checkStatusCode(int ... expectedStatuses) throws IOException {
        int statusCode;
        ImmutableSet<Integer> expectedSet = this.createExpectedSet(expectedStatuses);
        if (!expectedSet.contains((Object)(statusCode = this.getStatusCode()))) {
            String responseString = this.readResponseString();
            throw new FailedRequestException(ResponseUtils.toImmutableIntList(expectedStatuses), statusCode, AbstractResponse.parseErrorResponse(responseString), responseString);
        }
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    private ImmutableSet<Integer> createExpectedSet(int[] expectedStatuses) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (int status : expectedStatuses) {
            setBuilder.add((Object)status);
        }
        return setBuilder.build();
    }

    private static Error parseErrorResponse(String responseString) {
        if (Strings.isNullOrEmpty((String)responseString)) {
            return null;
        }
        try {
            return XmlOutput.fromXml(responseString, Error.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse error response", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private String readResponseString() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Checksum.Type getChecksumType() {
        return this.checksumType;
    }
}

