/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.ConnectionDetailsImpl;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.NetworkClientImpl;
import com.spectralogic.ds3client.commands.AllocateJobChunkRequest;
import com.spectralogic.ds3client.commands.AllocateJobChunkResponse;
import com.spectralogic.ds3client.commands.BulkGetRequest;
import com.spectralogic.ds3client.commands.BulkGetResponse;
import com.spectralogic.ds3client.commands.BulkPutRequest;
import com.spectralogic.ds3client.commands.BulkPutResponse;
import com.spectralogic.ds3client.commands.CancelJobRequest;
import com.spectralogic.ds3client.commands.CancelJobResponse;
import com.spectralogic.ds3client.commands.DeleteBucketRequest;
import com.spectralogic.ds3client.commands.DeleteBucketResponse;
import com.spectralogic.ds3client.commands.DeleteFolderRequest;
import com.spectralogic.ds3client.commands.DeleteFolderResponse;
import com.spectralogic.ds3client.commands.DeleteMultipleObjectsRequest;
import com.spectralogic.ds3client.commands.DeleteMultipleObjectsResponse;
import com.spectralogic.ds3client.commands.DeleteObjectRequest;
import com.spectralogic.ds3client.commands.DeleteObjectResponse;
import com.spectralogic.ds3client.commands.DeleteTapeDriveRequest;
import com.spectralogic.ds3client.commands.DeleteTapeDriveResponse;
import com.spectralogic.ds3client.commands.DeleteTapePartitionRequest;
import com.spectralogic.ds3client.commands.DeleteTapePartitionResponse;
import com.spectralogic.ds3client.commands.DeleteTapeRequest;
import com.spectralogic.ds3client.commands.DeleteTapeResponse;
import com.spectralogic.ds3client.commands.GetAvailableJobChunksRequest;
import com.spectralogic.ds3client.commands.GetAvailableJobChunksResponse;
import com.spectralogic.ds3client.commands.GetBucketRequest;
import com.spectralogic.ds3client.commands.GetBucketResponse;
import com.spectralogic.ds3client.commands.GetJobRequest;
import com.spectralogic.ds3client.commands.GetJobResponse;
import com.spectralogic.ds3client.commands.GetJobsRequest;
import com.spectralogic.ds3client.commands.GetJobsResponse;
import com.spectralogic.ds3client.commands.GetObjectRequest;
import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.commands.GetObjectsRequest;
import com.spectralogic.ds3client.commands.GetObjectsResponse;
import com.spectralogic.ds3client.commands.GetServiceRequest;
import com.spectralogic.ds3client.commands.GetServiceResponse;
import com.spectralogic.ds3client.commands.GetSystemHealthRequest;
import com.spectralogic.ds3client.commands.GetSystemHealthResponse;
import com.spectralogic.ds3client.commands.GetSystemInformationRequest;
import com.spectralogic.ds3client.commands.GetSystemInformationResponse;
import com.spectralogic.ds3client.commands.GetTapeDriveRequest;
import com.spectralogic.ds3client.commands.GetTapeDriveResponse;
import com.spectralogic.ds3client.commands.GetTapeDrivesRequest;
import com.spectralogic.ds3client.commands.GetTapeDrivesResponse;
import com.spectralogic.ds3client.commands.GetTapeFailureRequest;
import com.spectralogic.ds3client.commands.GetTapeFailureResponse;
import com.spectralogic.ds3client.commands.GetTapeLibrariesRequest;
import com.spectralogic.ds3client.commands.GetTapeLibrariesResponse;
import com.spectralogic.ds3client.commands.GetTapeLibraryRequest;
import com.spectralogic.ds3client.commands.GetTapeLibraryResponse;
import com.spectralogic.ds3client.commands.GetTapeRequest;
import com.spectralogic.ds3client.commands.GetTapeResponse;
import com.spectralogic.ds3client.commands.GetTapesRequest;
import com.spectralogic.ds3client.commands.GetTapesResponse;
import com.spectralogic.ds3client.commands.HeadBucketRequest;
import com.spectralogic.ds3client.commands.HeadBucketResponse;
import com.spectralogic.ds3client.commands.HeadObjectRequest;
import com.spectralogic.ds3client.commands.HeadObjectResponse;
import com.spectralogic.ds3client.commands.ModifyJobRequest;
import com.spectralogic.ds3client.commands.ModifyJobResponse;
import com.spectralogic.ds3client.commands.PutBucketRequest;
import com.spectralogic.ds3client.commands.PutBucketResponse;
import com.spectralogic.ds3client.commands.PutObjectRequest;
import com.spectralogic.ds3client.commands.PutObjectResponse;
import com.spectralogic.ds3client.commands.notifications.CreateJobCompletedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreateJobCreatedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreateObjectCachedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreateObjectLostNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreateObjectPersistedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreatePartitionFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.CreateTapeFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteJobCompletedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteJobCreatedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteNotificationResponse;
import com.spectralogic.ds3client.commands.notifications.DeleteObjectCachedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteObjectLostNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteObjectPersistedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeletePartitionFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.DeleteTapeFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetJobCompletedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetJobCreatedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetObjectCachedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetObjectLostNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetObjectPersistedNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetPartitionFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.GetTapeFailureNotificationRequest;
import com.spectralogic.ds3client.commands.notifications.NotificationResponse;
import com.spectralogic.ds3client.models.bulk.Node;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import com.spectralogic.ds3client.networking.NetworkClient;
import java.io.IOException;
import java.security.SignatureException;

public class Ds3ClientImpl
implements Ds3Client {
    private final NetworkClient netClient;

    public Ds3ClientImpl(NetworkClient netClient) {
        this.netClient = netClient;
    }

    NetworkClient getNetClient() {
        return this.netClient;
    }

    @Override
    public ConnectionDetails getConnectionDetails() {
        return this.netClient.getConnectionDetails();
    }

    @Override
    public GetServiceResponse getService(GetServiceRequest request) throws IOException, SignatureException {
        return new GetServiceResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetBucketResponse getBucket(GetBucketRequest request) throws IOException, SignatureException {
        return new GetBucketResponse(this.netClient.getResponse(request));
    }

    @Override
    public PutBucketResponse putBucket(PutBucketRequest request) throws IOException, SignatureException {
        return new PutBucketResponse(this.netClient.getResponse(request));
    }

    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest request) throws IOException, SignatureException {
        return new HeadBucketResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest request) throws IOException, SignatureException {
        return new DeleteBucketResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) throws IOException, SignatureException {
        return new DeleteFolderResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest request) throws IOException, SignatureException {
        return new DeleteObjectResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteMultipleObjectsResponse deleteMultipleObjects(DeleteMultipleObjectsRequest request) throws IOException, SignatureException {
        return new DeleteMultipleObjectsResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetObjectResponse getObject(GetObjectRequest request) throws IOException, SignatureException {
        return new GetObjectResponse(this.netClient.getResponse(request), request.getDestinationChannel(), this.netClient.getConnectionDetails().getBufferSize(), request.getObjectName());
    }

    @Override
    public GetObjectsResponse getObjects(GetObjectsRequest request) throws IOException, SignatureException {
        return new GetObjectsResponse(this.netClient.getResponse(request));
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest request) throws IOException, SignatureException {
        return new PutObjectResponse(this.netClient.getResponse(request));
    }

    @Override
    public HeadObjectResponse headObject(HeadObjectRequest request) throws IOException, SignatureException {
        return new HeadObjectResponse(this.netClient.getResponse(request));
    }

    @Override
    public BulkGetResponse bulkGet(BulkGetRequest request) throws IOException, SignatureException {
        return new BulkGetResponse(this.netClient.getResponse(request));
    }

    @Override
    public BulkPutResponse bulkPut(BulkPutRequest request) throws IOException, SignatureException {
        return new BulkPutResponse(this.netClient.getResponse(request));
    }

    @Override
    public AllocateJobChunkResponse allocateJobChunk(AllocateJobChunkRequest request) throws IOException, SignatureException {
        return new AllocateJobChunkResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetAvailableJobChunksResponse getAvailableJobChunks(GetAvailableJobChunksRequest request) throws IOException, SignatureException {
        return new GetAvailableJobChunksResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetJobsResponse getJobs(GetJobsRequest request) throws IOException, SignatureException {
        return new GetJobsResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) throws IOException, SignatureException {
        return new GetJobResponse(this.netClient.getResponse(request));
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest request) throws IOException, SignatureException {
        return new CancelJobResponse(this.netClient.getResponse(request));
    }

    @Override
    public ModifyJobResponse modifyJob(ModifyJobRequest request) throws IOException, SignatureException {
        return new ModifyJobResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteTapeDriveResponse deleteTapeDrive(DeleteTapeDriveRequest request) throws IOException, SignatureException {
        return new DeleteTapeDriveResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteTapePartitionResponse deleteTapePartition(DeleteTapePartitionRequest request) throws IOException, SignatureException {
        return new DeleteTapePartitionResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapesResponse getTapes(GetTapesRequest request) throws IOException, SignatureException {
        return new GetTapesResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteTapeResponse deleteTape(DeleteTapeRequest request) throws IOException, SignatureException {
        return new DeleteTapeResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeResponse getTape(GetTapeRequest request) throws IOException, SignatureException {
        return new GetTapeResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createObjectCachedNotification(CreateObjectCachedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getObjectCachedNotification(GetObjectCachedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteObjectCachedNotification(DeleteObjectCachedNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createJobCompletedNotification(CreateJobCompletedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getJobCompletedNotification(GetJobCompletedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteJobCompleteNotification(DeleteJobCompletedNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createJobCreatedNotification(CreateJobCreatedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getJobCreatedNotification(GetJobCreatedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteJobCreatedNotification(DeleteJobCreatedNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createObjectLostNotification(CreateObjectLostNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getObjectLostNotification(GetObjectLostNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteObjectLostNotification(DeleteObjectLostNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createObjectPersistedNotification(CreateObjectPersistedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getObjectPersistedNotification(GetObjectPersistedNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteObjectPersistedNotification(DeleteObjectPersistedNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createPartitionFailureNotification(CreatePartitionFailureNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getPartitionFailureNotification(GetPartitionFailureNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deletePartitionFailureNotification(DeletePartitionFailureNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse createTapeFailureNotification(CreateTapeFailureNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public NotificationResponse getTapeFailureNotification(GetTapeFailureNotificationRequest request) throws IOException, SignatureException {
        return new NotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public DeleteNotificationResponse deleteTapeFailureNotification(DeleteTapeFailureNotificationRequest request) throws IOException, SignatureException {
        return new DeleteNotificationResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetSystemHealthResponse getSystemHealth(GetSystemHealthRequest request) throws IOException, SignatureException {
        return new GetSystemHealthResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetSystemInformationResponse getSystemInformation(GetSystemInformationRequest request) throws IOException, SignatureException {
        return new GetSystemInformationResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeLibrariesResponse getTapeLibraries(GetTapeLibrariesRequest request) throws IOException, SignatureException {
        return new GetTapeLibrariesResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeLibraryResponse getTapeLibrary(GetTapeLibraryRequest request) throws IOException, SignatureException {
        return new GetTapeLibraryResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeDrivesResponse getTapeDrives(GetTapeDrivesRequest request) throws IOException, SignatureException {
        return new GetTapeDrivesResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeDriveResponse getTapeDrive(GetTapeDriveRequest request) throws IOException, SignatureException {
        return new GetTapeDriveResponse(this.netClient.getResponse(request));
    }

    @Override
    public GetTapeFailureResponse getTapeFailure(GetTapeFailureRequest request) throws IOException, SignatureException {
        return new GetTapeFailureResponse(this.netClient.getResponse(request));
    }

    @Override
    public Ds3Client newForNode(Node node) {
        ConnectionDetails newConnectionDetails = ConnectionDetailsImpl.newForNode(node, this.getConnectionDetails());
        NetworkClientImpl newNetClient = new NetworkClientImpl(newConnectionDetails);
        return new Ds3ClientImpl(newNetClient);
    }

    @Override
    public void close() throws IOException {
        this.netClient.close();
    }
}

