/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.testutils.filemanip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.irods.jargon.testutils.TestingPropertiesHelper;
import org.irods.jargon.testutils.TestingUtilsException;
import org.irods.jargon.testutils.filemanip.ScratchFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGenerator {
    public static List<String> fileExtensions = new ArrayList<String>();
    private static final Random RANDOM = new Random();
    private static Properties testingProperties = new Properties();
    private static TestingPropertiesHelper testingPropertiesHelper = new TestingPropertiesHelper();
    private static Logger log = LoggerFactory.getLogger(FileGenerator.class);

    protected static String generateRandomExtension() throws TestingUtilsException {
        return fileExtensions.get(FileGenerator.generateRandomNumber(0, fileExtensions.size()));
    }

    public static String generateRandomString(int length) {
        StringBuilder outString = new StringBuilder();
        Random generator = new Random();
        char theChar = '\u0000';
        int outLength = 0;
        while (outLength < length) {
            theChar = (char)(generator.nextInt(65) + 65);
            if (!Character.isLetter(theChar)) continue;
            outString.append(theChar);
            ++outLength;
        }
        return outString.toString();
    }

    protected static String generateRandomFileName(int length) throws TestingUtilsException {
        StringBuilder fileName = new StringBuilder();
        fileName.append(FileGenerator.generateRandomString(length));
        fileName.append(FileGenerator.generateRandomExtension());
        return fileName.toString();
    }

    public static String generateFileOfFixedLengthGivenName(String fileDirectory, String fileName, long length) throws TestingUtilsException {
        if (fileDirectory == null || fileDirectory.isEmpty()) {
            throw new IllegalArgumentException("null or empty FileDirectory");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        File dir = new File(fileDirectory);
        dir.mkdirs();
        long chunkSize = 1023L;
        if (length <= chunkSize) {
            chunkSize = length;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int generatedLength = 0;
        while ((long)generatedLength < chunkSize) {
            bos.write(RANDOM.nextInt());
            ++generatedLength;
        }
        byte[] fileChunk = bos.toByteArray();
        File randFile = new File(fileDirectory, fileName);
        OutputStream outStream = null;
        long generatedFileLength = 0L;
        long nextChunkSize = 0L;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(randFile));
            while (generatedFileLength < length) {
                nextChunkSize = length - generatedFileLength;
                if (nextChunkSize > chunkSize) {
                    outStream.write(fileChunk);
                    generatedFileLength += chunkSize;
                    continue;
                }
                outStream.write(fileChunk, 0, (int)nextChunkSize);
                generatedFileLength += nextChunkSize;
            }
        }
        catch (IOException ioe) {
            throw new TestingUtilsException("error generating random file with dir:" + fileDirectory + " and generated name:" + fileName, ioe);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception exception) {}
            }
        }
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(fileDirectory);
        fullPath.append(fileName);
        return fullPath.toString();
    }

    public static int generateRandomNumber(int min, int max) throws TestingUtilsException {
        if (max < min) {
            throw new TestingUtilsException("max length must be > or = min length");
        }
        int range = max - min;
        if (range <= 0) {
            range = 2;
        }
        Random generator = new Random();
        return min + generator.nextInt(range);
    }

    public static void generateManyFilesAndCollectionsInParentCollectionByAbsolutePath(String absolutePathToLocalParentCollection, String collectionPrefix, int numberOfCollectionsMin, int numberOfCollectionsMax, int depth, String filePrefix, String fileSuffix, int maxNumberOfFiles, int minNumberOfFiles, int fileLengthMin, int fileLengthMax) throws TestingUtilsException {
        int numberThisParent = numberOfCollectionsMin == numberOfCollectionsMax ? numberOfCollectionsMin : FileGenerator.generateRandomNumber(numberOfCollectionsMin, numberOfCollectionsMax);
        if (depth == 0) {
            return;
        }
        for (int i = 0; i < numberThisParent; ++i) {
            StringBuilder subdirName = new StringBuilder();
            subdirName.append(collectionPrefix);
            subdirName.append("lvl");
            subdirName.append(depth);
            subdirName.append("nbr");
            subdirName.append(i);
            subdirName.append('/');
            StringBuilder absolutePath = new StringBuilder();
            absolutePath.append(absolutePathToLocalParentCollection);
            absolutePath.append((CharSequence)subdirName);
            File localFile = new File(absolutePath.toString());
            boolean success = localFile.mkdirs();
            if (!success) {
                log.warn("mkdirs for {} did not return success", (Object)localFile.getAbsolutePath());
            }
            int numberOfFiles = minNumberOfFiles == maxNumberOfFiles ? minNumberOfFiles : FileGenerator.generateRandomNumber(minNumberOfFiles, maxNumberOfFiles);
            log.debug("generating {} files", (Object)numberOfFiles);
            FileGenerator.generateManyFilesInParentCollectionByAbsolutePath(localFile.getAbsolutePath() + '/', filePrefix, fileSuffix, numberOfFiles, fileLengthMin, fileLengthMax);
            FileGenerator.generateManyFilesAndCollectionsInParentCollectionByAbsolutePath(localFile.getAbsolutePath() + "/", collectionPrefix, numberOfCollectionsMin, numberOfCollectionsMax, depth - 1, filePrefix, fileSuffix, maxNumberOfFiles, minNumberOfFiles, fileLengthMin, fileLengthMax);
        }
    }

    public static void generateManyFilesInParentCollectionByAbsolutePath(String absolutePathToLocalCollection, String filePrefix, String fileSuffix, int numberOfFiles, int fileLengthMin, int fileLengthMax) throws TestingUtilsException {
        String genFileName = "";
        for (int i = 0; i < numberOfFiles; ++i) {
            genFileName = filePrefix + i + fileSuffix;
            FileGenerator.generateFileOfFixedLengthGivenName(absolutePathToLocalCollection, genFileName, FileGenerator.generateRandomNumber(fileLengthMin, fileLengthMax));
        }
    }

    public static List<String> generateManyFilesInGivenDirectory(String relativePathUnderScratch, String filePrefix, String fileSuffix, int numberOfFiles, int fileLengthMin, int fileLengthMax) throws TestingUtilsException {
        ScratchFileUtils scratchFileUtils = new ScratchFileUtils(testingProperties);
        String absPath = scratchFileUtils.createAndReturnAbsoluteScratchPath(relativePathUnderScratch);
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        String genFileName = "";
        for (int i = 0; i < numberOfFiles; ++i) {
            genFileName = filePrefix + i + fileSuffix;
            genFileName = FileGenerator.generateFileOfFixedLengthGivenName(absPath, genFileName, FileGenerator.generateRandomNumber(fileLengthMin, fileLengthMax));
            sourceFileNames.add(genFileName);
        }
        return sourceFileNames;
    }

    static {
        fileExtensions.add(".doc");
        fileExtensions.add(".txt");
        fileExtensions.add(".csv");
        fileExtensions.add(".gif");
        fileExtensions.add(".jpg");
        fileExtensions.add(".avi");
        try {
            testingProperties = testingPropertiesHelper.getTestProperties();
        }
        catch (TestingUtilsException e) {
            throw new IllegalStateException("cannot find testing properties", e);
        }
    }
}

