/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.util.concurrent.ConcurrentHashMap;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.FileRestartDataSegment;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.FileRestartInfoIdentifier;
import org.irods.jargon.core.transfer.FileRestartManagementException;
import org.irods.jargon.core.transfer.RestartFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBasedTransferRestartManager
extends AbstractRestartManager {
    private static final Logger log = LoggerFactory.getLogger(MemoryBasedTransferRestartManager.class);
    private final ConcurrentHashMap<FileRestartInfoIdentifier, FileRestartInfo> cacheOfRestartInfo = new ConcurrentHashMap(8, 0.9f, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileRestartInfoIdentifier storeRestart(FileRestartInfo fileRestartInfo) throws FileRestartManagementException {
        FileRestartInfoIdentifier identifier;
        log.info("storeRestart()");
        if (fileRestartInfo == null) {
            throw new IllegalArgumentException("null fileRestartInfo");
        }
        MemoryBasedTransferRestartManager memoryBasedTransferRestartManager = this;
        synchronized (memoryBasedTransferRestartManager) {
            identifier = FileRestartInfoIdentifier.instanceFromFileRestartInfo(fileRestartInfo);
            this.cacheOfRestartInfo.put(identifier, fileRestartInfo);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRestart(FileRestartInfoIdentifier fileRestartInfoIdentifier) throws FileRestartManagementException {
        log.info("deleteRestart()");
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null fileRestartInfoIdentifier");
        }
        MemoryBasedTransferRestartManager memoryBasedTransferRestartManager = this;
        synchronized (memoryBasedTransferRestartManager) {
            this.cacheOfRestartInfo.remove(fileRestartInfoIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileRestartInfo retrieveRestart(FileRestartInfoIdentifier fileRestartInfoIdentifier) throws FileRestartManagementException {
        log.info("retrieveRestart()");
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null fileRestartInfoIdentifier");
        }
        MemoryBasedTransferRestartManager memoryBasedTransferRestartManager = this;
        synchronized (memoryBasedTransferRestartManager) {
            return this.cacheOfRestartInfo.get(fileRestartInfoIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSegment(FileRestartInfo fileRestartInfo, FileRestartDataSegment fileRestartDataSegment) throws FileRestartManagementException {
        log.info("updateSegment()");
        if (fileRestartInfo == null) {
            throw new IllegalArgumentException("null fileRestartInfo");
        }
        if (fileRestartDataSegment == null) {
            throw new IllegalArgumentException("null fileRestartDataSegment");
        }
        log.info("updating fileRestartInfo:{}", (Object)fileRestartInfo);
        log.info("updating fileRestartDataSegment:{}", (Object)fileRestartDataSegment);
        MemoryBasedTransferRestartManager memoryBasedTransferRestartManager = this;
        synchronized (memoryBasedTransferRestartManager) {
            FileRestartInfo actualRestartInfo = this.retrieveRestart(fileRestartInfo.identifierFromThisInfo());
            if (actualRestartInfo.getFileRestartDataSegments().size() < fileRestartDataSegment.getThreadNumber()) {
                log.error("fileRestartInfo does not contain the given segment:{}", (Object)fileRestartInfo);
                throw new FileRestartManagementException("unable to find segment");
            }
            FileRestartDataSegment actualSegment = actualRestartInfo.getFileRestartDataSegments().get(fileRestartDataSegment.getThreadNumber());
            if (actualSegment.getThreadNumber() != fileRestartDataSegment.getThreadNumber()) {
                log.error("mismatch in thread number in update request for segment:{}", (Object)fileRestartDataSegment);
                throw new FileRestartManagementException("file segment does not match thread number");
            }
            actualRestartInfo.getFileRestartDataSegments().set(actualSegment.getThreadNumber(), fileRestartDataSegment);
            this.storeRestart(actualRestartInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileRestartInfo incrementRestartAttempts(FileRestartInfo fileRestartInfo) throws RestartFailedException, FileRestartManagementException {
        log.info("incrementRestartAttempts()");
        if (fileRestartInfo == null) {
            log.info("no restart to increment, returning null");
            return null;
        }
        log.info("fileRestartInfo:{}", (Object)fileRestartInfo);
        MemoryBasedTransferRestartManager memoryBasedTransferRestartManager = this;
        synchronized (memoryBasedTransferRestartManager) {
            FileRestartInfo actualRestartInfo = this.retrieveRestart(fileRestartInfo.identifierFromThisInfo());
            if (actualRestartInfo == null) {
                log.error("nothing to increment!");
                return null;
            }
            int currentRestarts = actualRestartInfo.getNumberRestarts();
            if (++currentRestarts > 4) {
                log.error("violates max restart attempts, go ahead and fail the restart attempt");
                throw new RestartFailedException("restart failed with too many attempts");
            }
            actualRestartInfo.setNumberRestarts(currentRestarts);
            this.storeRestart(actualRestartInfo);
            return fileRestartInfo;
        }
    }
}

