/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.service.AbstractJargonService;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.FileRestartInfoIdentifier;
import org.irods.jargon.core.transfer.FileRestartManagementException;
import org.irods.jargon.core.transfer.RestartFailedException;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransferRestartProcessor
extends AbstractJargonService {
    private final AbstractRestartManager restartManager;
    private static Logger log = LoggerFactory.getLogger(AbstractTransferRestartProcessor.class);
    private final TransferStatusCallbackListener transferStatusCallbackListener;
    private final TransferControlBlock transferControlBlock;
    public static final long RESTART_FILE_UPDATE_SIZE = 0x2000000L;

    public AbstractTransferRestartProcessor(IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount, AbstractRestartManager restartManager, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) {
        super(irodsAccessObjectFactory, irodsAccount);
        if (restartManager == null) {
            throw new IllegalArgumentException("null restartManager");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        this.transferControlBlock = transferControlBlock;
        this.transferStatusCallbackListener = transferStatusCallbackListener;
        this.restartManager = restartManager;
    }

    public AbstractRestartManager getRestartManager() {
        return this.restartManager;
    }

    public abstract void restartIfNecessary(String var1) throws RestartFailedException, FileRestartManagementException, JargonException;

    protected RandomAccessFile localFileAsFileAndCheckExists(FileRestartInfo fileRestartInfo, OpenType openType) throws FileNotFoundException, JargonException {
        log.info("localFileAsFileAndCheckExists()");
        RandomAccessFile localFile = this.localFileAsFile(fileRestartInfo, openType);
        return localFile;
    }

    protected RandomAccessFile localFileAsFile(FileRestartInfo fileRestartInfo, OpenType openType) throws JargonException {
        log.info("localFileAsFileAndCheckExists()");
        if (fileRestartInfo == null) {
            throw new IllegalArgumentException("null fileRestartInfo");
        }
        if (openType == null) {
            throw new IllegalArgumentException("null openType");
        }
        if (fileRestartInfo.getLocalAbsolutePath() == null || fileRestartInfo.getLocalAbsolutePath().isEmpty()) {
            log.error("no localFilePath in restart info for:{}", (Object)fileRestartInfo);
            throw new JargonException("unable to find a local file path in the restart info");
        }
        String openFlag = openType == OpenType.READ ? "r" : "rw";
        try {
            return new RandomAccessFile(fileRestartInfo.getLocalAbsolutePath(), openFlag);
        }
        catch (FileNotFoundException e) {
            log.error("local file not found:{}", (Object)fileRestartInfo.getLocalAbsolutePath());
            throw new JargonException("cannot find local file");
        }
    }

    protected FileRestartInfo retrieveFileRestartInfoForIdentifier(FileRestartInfoIdentifier fileRestartInfoIdentifier) throws FileRestartManagementException {
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null fileRestartInfoIdentifier");
        }
        if (this.getRestartManager() == null) {
            throw new JargonRuntimeException("no restart manager configured");
        }
        return this.getRestartManager().retrieveRestart(fileRestartInfoIdentifier);
    }

    protected FileRestartInfo retrieveRestartIfConfiguredOrNull(String irodsAbsolutePath, FileRestartInfo.RestartType restartType) throws FileRestartManagementException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        try {
            if (this.getIrodsAccessObjectFactory().getJargonProperties().isLongTransferRestart() && this.getRestartManager() == null) {
                log.error("no restart manager configured");
                throw new FileRestartManagementException("retart manager not configured");
            }
        }
        catch (JargonException e) {
            log.error("exception accessing restart manager", (Throwable)e);
            throw new FileRestartManagementException("retart manager error", e);
        }
        FileRestartInfoIdentifier fileRestartInfoIdentifier = new FileRestartInfoIdentifier();
        fileRestartInfoIdentifier.setAbsolutePath(irodsAbsolutePath);
        fileRestartInfoIdentifier.setIrodsAccountIdentifier(this.getIrodsAccount().toString());
        fileRestartInfoIdentifier.setRestartType(restartType);
        log.info("see if restart for:{}", (Object)fileRestartInfoIdentifier);
        FileRestartInfo fileRestartInfo = this.getRestartManager().retrieveRestart(fileRestartInfoIdentifier);
        return fileRestartInfo;
    }

    public TransferStatusCallbackListener getTransferStatusCallbackListener() {
        return this.transferStatusCallbackListener;
    }

    public TransferControlBlock getTransferControlBlock() {
        return this.transferControlBlock;
    }

    public static enum OpenType {
        READ,
        WRITE;

    }
}

