/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNIOParallelTransferThread {
    protected static final String IO_EXCEPTION_OCCURRED_DURING_PARALLEL_FILE_TRANSFER = "IOException occurred during parallel file transfer";
    protected static final String IO_EXEPTION_IN_PARALLEL_TRANSFER = "IOExeption in parallel transfer";
    private SocketChannel s;
    private Exception exceptionInTransfer = null;
    public static final int DONE_OPR = 9999;
    public static final int PUT_OPR = 1;
    public static final int GET_OPR = 2;
    public static final Logger log = LoggerFactory.getLogger(AbstractNIOParallelTransferThread.class);

    protected AbstractNIOParallelTransferThread() {
    }

    private ByteBuffer readLenFromSocket(int length) throws JargonException {
        ByteBuffer b = ByteBuffer.allocate(length);
        int tot = 0;
        try {
            int read = this.getS().read(b);
            while (read != -1) {
                if (Thread.interrupted()) {
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                if ((tot += read) != length) {
                    read = this.getS().read(b);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(IO_EXEPTION_IN_PARALLEL_TRANSFER, (Throwable)e);
            throw new JargonException(IO_EXCEPTION_OCCURRED_DURING_PARALLEL_FILE_TRANSFER, e);
        }
        return b;
    }

    protected int readInt() throws JargonException {
        int len = 4;
        byte[] bAsByte = new byte[len];
        ByteBuffer b = this.readLenFromSocket(len);
        b.flip();
        b.get(bAsByte);
        return Host.castToInt(bAsByte);
    }

    protected long readLong() throws JargonException {
        int len = 8;
        byte[] bAsByte = new byte[len];
        ByteBuffer b = this.readLenFromSocket(len);
        b.flip();
        b.get(bAsByte);
        return Host.castToLong(bAsByte);
    }

    public void close() throws JargonException {
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException e) {
                log.warn("IOException on close - LOG and ignore");
            }
            this.s = null;
        }
    }

    protected final SocketChannel getS() {
        return this.s;
    }

    protected final void setS(SocketChannel s) {
        this.s = s;
    }

    public Exception getExceptionInTransfer() {
        return this.exceptionInTransfer;
    }

    protected void setExceptionInTransfer(Exception exceptionInTransfer) {
        this.exceptionInTransfer = exceptionInTransfer;
    }
}

