/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.query.AbstractAliasedQuery;

public class SimpleQueryInp
extends AbstractIRODSPackingInstruction {
    private final AbstractAliasedQuery simpleQuery;
    private static final int maxBuffSize = 1024;
    public static final String PI_TAG = "simpleQueryInp_PI";
    public static final int SIMPLE_QUERY_API_NBR = 614;
    public static final String SQL = "sql";
    public static final String ARG1 = "arg1";
    public static final String ARG2 = "arg2";
    public static final String ARG3 = "arg3";
    public static final String ARG4 = "arg4";
    public static final String CONTROL = "control";
    public static final String FORM = "form";
    public static final String MAX_BUF_SIZE = "maxBufSize";

    public static SimpleQueryInp instance(AbstractAliasedQuery simpleQuery) {
        return new SimpleQueryInp(614, simpleQuery);
    }

    public AbstractAliasedQuery getSimpleQuery() {
        return this.simpleQuery;
    }

    public int getMaxBuffSize() {
        return 1024;
    }

    private SimpleQueryInp(int apiNbr, AbstractAliasedQuery simpleQuery) {
        if (apiNbr <= 0) {
            throw new IllegalArgumentException("negative or zero apiNbr");
        }
        if (simpleQuery == null) {
            throw new IllegalArgumentException("simpleQuery is null");
        }
        this.simpleQuery = simpleQuery;
        this.setApiNumber(apiNbr);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        String arg1 = "";
        String arg2 = "";
        String arg3 = "";
        String arg4 = "";
        int sz = this.simpleQuery.getArguments().size();
        if (sz > 0 && this.simpleQuery.getArguments().get(0) != null) {
            arg1 = this.simpleQuery.getArguments().get(0);
        }
        if (sz > 1 && this.simpleQuery.getArguments().get(1) != null) {
            arg2 = this.simpleQuery.getArguments().get(1);
        }
        if (sz > 2 && this.simpleQuery.getArguments().get(2) != null) {
            arg3 = this.simpleQuery.getArguments().get(2);
        }
        if (sz > 3 && this.simpleQuery.getArguments().get(3) != null) {
            arg4 = this.simpleQuery.getArguments().get(3);
        }
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(SQL, this.simpleQuery.getQueryString()), new Tag(ARG1, arg1), new Tag(ARG2, arg2), new Tag(ARG3, arg3), new Tag(ARG4, arg4), new Tag(CONTROL, this.simpleQuery.getContinuationValue()), new Tag(FORM, 2), new Tag(MAX_BUF_SIZE, 1024)});
        return message;
    }
}

