/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.SpecColInfo;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjInpForQuerySpecColl
extends AbstractIRODSPackingInstruction {
    public static final int QUERY_SPEC_COLL_API_NBR = 645;
    private String fileAbsolutePath = "";
    private final long offset = 0L;
    private final int operationType = 0;
    private String selObjType = null;
    private final SpecColInfo specColInfo;
    private final int continueInx;

    public static final DataObjInpForQuerySpecColl instanceQueryDataObj(String fileAbsolutePath, SpecColInfo specColInfo) throws JargonException {
        return new DataObjInpForQuerySpecColl(fileAbsolutePath, "dataObj", specColInfo, 0);
    }

    public static final DataObjInpForQuerySpecColl instanceQueryDataObj(String fileAbsolutePath, SpecColInfo specColInfo, int continueInx) throws JargonException {
        return new DataObjInpForQuerySpecColl(fileAbsolutePath, "dataObj", specColInfo, continueInx);
    }

    public static final DataObjInpForQuerySpecColl instanceQueryCollections(String fileAbsolutePath, SpecColInfo specColInfo) throws JargonException {
        if (specColInfo == null) {
            throw new IllegalArgumentException("null specColInfo");
        }
        return new DataObjInpForQuerySpecColl(fileAbsolutePath, "collection", specColInfo, 0);
    }

    public static final DataObjInpForQuerySpecColl instanceQueryCollections(String fileAbsolutePath, SpecColInfo specColInfo, int continueInx) throws JargonException {
        if (specColInfo == null) {
            throw new IllegalArgumentException("null specColInfo");
        }
        return new DataObjInpForQuerySpecColl(fileAbsolutePath, "collection", specColInfo, continueInx);
    }

    private DataObjInpForQuerySpecColl(String fileAbsolutePath, String selObjType, SpecColInfo specColInfo, int continueInx) throws JargonException {
        if (fileAbsolutePath == null || fileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("file absolute path is null or empty");
        }
        if (selObjType == null || selObjType.length() == 0) {
            throw new IllegalArgumentException("selObjType is null or empty");
        }
        if (continueInx < 0) {
            throw new IllegalArgumentException("continueInx < 0");
        }
        this.fileAbsolutePath = fileAbsolutePath;
        this.selObjType = selObjType;
        this.specColInfo = specColInfo;
        this.setApiNumber(645);
        this.continueInx = continueInx;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", this.getFileAbsolutePath()), new Tag("createMode", 0), new Tag("openFlags", this.continueInx), new Tag("offset", 0L), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", 0)});
        if (this.specColInfo != null) {
            message.addTag(this.createSpecCollTag(this.specColInfo));
        }
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        kvps.add(KeyValuePair.instance("selObjType", this.selObjType));
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }
}

