/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjInpForFileLock
extends AbstractIRODSPackingInstruction {
    public static final int LOCK_API_NBR = 699;
    public static final String READ_LOCK_TYPE = "readLockType";
    public static final String WRITE_LOCK_TYPE = "writeLockType";
    public static final String UNLOCK_TYPE = "unlockType";
    public static final String SET_LOCK_CMD = "setLockCmd";
    public static final String SET_LOCK_WAIT_CMD = "setLockWaitCmd";
    public static final String GET_LOCK_CMD = "getLockCmd";
    public static final String LOCK_TYPE_KW = "lockType";
    public static final String LOCK_CMD_KW = "lockCmd";
    public static final String LOCK_FD_KW = "lockFd";
    private String fileAbsolutePath = "";
    private LockType lockType = LockType.READ_LOCK;
    private LockCommandType lockCommandType = LockCommandType.SET_LOCK;
    private int fd = -1;

    public static final DataObjInpForFileLock instance(String fileAbsolutePath, LockType lockType, LockCommandType lockCommandType) throws JargonException {
        return new DataObjInpForFileLock(fileAbsolutePath, lockType, lockCommandType, -1);
    }

    private DataObjInpForFileLock(String fileAbsolutePath, LockType lockType, LockCommandType lockCommandType, int fd) throws JargonException {
        if (fileAbsolutePath == null || fileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileAbsolutePath");
        }
        if (lockType == null) {
            throw new IllegalArgumentException("null lockType");
        }
        if (lockCommandType == null) {
            throw new IllegalArgumentException("null lockCommandType");
        }
        this.fileAbsolutePath = fileAbsolutePath;
        this.lockType = lockType;
        this.lockCommandType = lockCommandType;
        this.fd = fd;
        this.setApiNumber(699);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        String lockCommandVal;
        String lockTypeVal;
        Tag message = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", this.getFileAbsolutePath()), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", 0)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        switch (this.lockType) {
            case WRITE_LOCK: {
                lockTypeVal = WRITE_LOCK_TYPE;
                break;
            }
            case READ_LOCK: {
                lockTypeVal = READ_LOCK_TYPE;
                break;
            }
            case UNLOCK: {
                lockTypeVal = UNLOCK_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown lock type");
            }
        }
        kvps.add(KeyValuePair.instance(LOCK_TYPE_KW, lockTypeVal));
        switch (this.lockCommandType) {
            case SET_LOCK: {
                lockCommandVal = SET_LOCK_CMD;
                break;
            }
            case SET_LOCK_WAIT: {
                lockCommandVal = SET_LOCK_WAIT_CMD;
                break;
            }
            case GET_LOCK: {
                lockCommandVal = GET_LOCK_CMD;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid lockCommandType");
            }
        }
        kvps.add(KeyValuePair.instance(LOCK_CMD_KW, lockCommandVal));
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    public LockType getLockType() {
        return this.lockType;
    }

    public LockCommandType getLockCommandType() {
        return this.lockCommandType;
    }

    public int getFd() {
        return this.fd;
    }

    public static enum LockCommandType {
        SET_LOCK,
        SET_LOCK_WAIT,
        GET_LOCK;

    }

    public static enum LockType {
        READ_LOCK,
        WRITE_LOCK,
        UNLOCK;

    }
}

