/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;

public class GSIIRODSAccount
extends IRODSAccount {
    private static final long serialVersionUID = -2165721910428546185L;
    private final transient GSSCredential gssCredential;
    private final String distinguishedName;
    private String serverDistinguishedName = "";
    private String certificateAuthority = "";

    public static GSIIRODSAccount instance(String host, int port, GSSCredential gssCredential, String defaultStorageResource) throws JargonException {
        return new GSIIRODSAccount(host, port, gssCredential, defaultStorageResource);
    }

    private GSIIRODSAccount(String host, int port, GSSCredential gssCredential, String defaultStorageResource) throws JargonException {
        super(host, port, "", "", "", "", defaultStorageResource);
        if (gssCredential == null) {
            throw new IllegalArgumentException("null gssCredential");
        }
        this.gssCredential = gssCredential;
        try {
            this.distinguishedName = gssCredential.getName().toString();
        }
        catch (GSSException e) {
            throw new JargonException("GSSException getting distinguished name", e);
        }
        this.setAuthenticationScheme(AuthScheme.GSI);
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public String getServerDistinguishedName() {
        return this.serverDistinguishedName;
    }

    void setServerDistinguishedName(String serverDistinguishedName) {
        this.serverDistinguishedName = serverDistinguishedName;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public void setCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            GSIIRODSAccount temp = (GSIIRODSAccount)obj;
            if (!this.getHost().equals(temp.getHost())) {
                return false;
            }
            if (this.getPort() != temp.getPort()) {
                return false;
            }
            return this.getDistinguishedName().equals(temp.getDistinguishedName());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.getHost().hashCode() + this.getPort() + this.getDistinguishedName().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("irods://");
        sb.append(this.getDistinguishedName());
        sb.append("@");
        sb.append(this.getHost());
        sb.append(":");
        sb.append(this.getPort());
        return sb.toString();
    }
}

