/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.crypto.macs.HMac;

public class HmacOutputStream
extends OutputStream {
    private HMac hmac;
    private OutputStream out;

    private HmacOutputStream() {
    }

    public HmacOutputStream(HMac hmac, OutputStream chained) {
        Validate.notNull((Object)hmac, (String)"HMAC instance must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)chained, (String)"OutputStream must not be null", (Object[])new Object[0]);
        this.hmac = hmac;
        this.out = chained;
    }

    public HMac getHmac() {
        return this.hmac;
    }

    @Override
    public void write(int b) throws IOException {
        this.hmac.update((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.hmac.update(buffer, 0, buffer.length);
        this.out.write(buffer);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.hmac.update(buffer, offset, length);
        this.out.write(buffer, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

