/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class EmbeddedHttpContent
implements HttpEntity {
    private static final long CLOSED_CHECK_INTERVAL = 50L;
    private volatile OutputStream writer;
    private final String contentType;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public EmbeddedHttpContent(String contentType, AtomicBoolean closed) {
        this.contentType = contentType;
        this.closed = closed;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        this.writer = out;
        while (!this.closed.get()) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", this.contentType);
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent is not supported");
    }

    public boolean isStreaming() {
        return false;
    }

    @Deprecated
    public void consumeContent() throws IOException {
        throw new UnsupportedOperationException("consumeContent is not supported");
    }

    public OutputStream getWriter() {
        return this.writer;
    }
}

