/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.config.ConfigContext;
import java.time.Duration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class MantaServiceUnavailableRetryStrategy
extends DefaultServiceUnavailableRetryStrategy {
    private static final int RETRY_INTERVAL = (int)Duration.ofSeconds(1L).toMillis();

    public MantaServiceUnavailableRetryStrategy(ConfigContext context) {
        super(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{context.getRetries(), 3})).intValue(), RETRY_INTERVAL);
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        Object disableRetry = context.getAttribute("manta.retry.disable");
        if (disableRetry instanceof Boolean && ((Boolean)disableRetry).booleanValue()) {
            return false;
        }
        return super.retryRequest(response, executionCount, context);
    }
}

