/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.config.ConfigContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final List<Class<? extends IOException>> NON_RETRIABLE = Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class);
    public static final String CONTEXT_ATTRIBUTE_MANTA_RETRY_DISABLE = "manta.retry.disable";

    public MantaHttpRequestRetryHandler(ConfigContext config) {
        super(config.getRetries().intValue(), true, NON_RETRIABLE);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Object disableRetry = context.getAttribute(CONTEXT_ATTRIBUTE_MANTA_RETRY_DISABLE);
        if (disableRetry instanceof Boolean && ((Boolean)disableRetry).booleanValue()) {
            return false;
        }
        if (this.logger.isDebugEnabled() && executionCount <= this.getRetryCount()) {
            String msg = String.format("Request failed, %d/%d retry.", executionCount, this.getRetryCount());
            this.logger.debug(msg, (Throwable)exception);
        }
        return super.retryRequest(exception, executionCount, context);
    }
}

