/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.http.signature.apache.httpclient.HttpSignatureAuthScheme;
import com.joyent.manta.config.AuthAwareConfigContext;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

class DynamicHttpSignatureRequestInterceptor
implements HttpRequestInterceptor {
    private final AuthAwareConfigContext authConfig;

    DynamicHttpSignatureRequestInterceptor(AuthAwareConfigContext authConfig) {
        this.authConfig = authConfig;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (this.authConfig.noAuth().booleanValue()) {
            return;
        }
        long start = System.nanoTime();
        HttpSignatureAuthScheme authScheme = this.authConfig.getAuthScheme();
        Header authorization = authScheme.authenticate(this.authConfig.getCredentials(), request, context);
        long end = System.nanoTime();
        request.setHeader(authorization);
        request.setHeader("x-http-signing-time-ns", String.valueOf(end - start));
    }
}

