/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jets3t.service.ServiceException;

public class SpectraReadFeature
implements Read {
    private final PathContainerService containerService = new S3PathContainerService();
    private final SpectraSession session;
    private final SpectraBulkService bulk;

    public SpectraReadFeature(SpectraSession session) {
        this(session, new SpectraBulkService(session));
    }

    public SpectraReadFeature(SpectraSession session, SpectraBulkService bulk) {
        this.session = session;
        this.bulk = bulk;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        List<TransferStatus> chunks = this.bulk.query(Transfer.Type.download, file, status);
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        try {
            for (TransferStatus chunk : chunks) {
                InputStream in = ((RequestEntityRestStorageService)this.session.getClient()).getObjectImpl(false, this.containerService.getContainer(file).getName(), this.containerService.getKey(file), null, null, null, null, null, null, null, new HashMap(), chunk.getParameters()).getDataInputStream();
                streams.add(in);
            }
            return new SequenceInputStream(Collections.enumeration(streams));
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) {
        return false;
    }
}

