/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.jnagmp;

import com.squareup.jnagmp.GmpInteger;
import com.squareup.jnagmp.LibGmp;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.math.BigInteger;

public final class Gmp {
    private static final UnsatisfiedLinkError LOAD_ERROR;
    static final ThreadLocal<Gmp> INSTANCE;
    private static final int INITIAL_BUF_BITS = 2048;
    private static final int INITIAL_BUF_SIZE = 256;
    private static final int MAX_OPERANDS = 4;
    private static final int SHARED_MEM_SIZE;
    private final LibGmp.mpz_t[] sharedOperands = new LibGmp.mpz_t[4];
    private final Pointer countPtr;
    private final Memory sharedMem = new Memory(SHARED_MEM_SIZE){

        protected void finalize() {
            for (LibGmp.mpz_t sharedOperand : Gmp.this.sharedOperands) {
                if (sharedOperand == null) continue;
                LibGmp.__gmpz_clear(sharedOperand);
            }
            super.finalize();
        }
    };
    private Memory scratchBuf = new Memory(256L);
    private static final NativeLong ZERO;

    public static void checkLoaded() {
        if (LOAD_ERROR != null) {
            throw LOAD_ERROR;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger three = BigInteger.valueOf(3L);
        BigInteger four = BigInteger.valueOf(4L);
        BigInteger five = BigInteger.valueOf(5L);
        BigInteger answer = Gmp.modPowInsecure(two, three, five);
        if (!three.equals(answer)) {
            throw new AssertionError((Object)"libgmp is loaded but modPowInsecure returned the wrong answer");
        }
        answer = Gmp.modPowSecure(two, three, five);
        if (!three.equals(answer)) {
            throw new AssertionError((Object)"libgmp is loaded but modPowSecure returned the wrong answer");
        }
        int answr = Gmp.kronecker(four, five);
        if (answr != 1) {
            throw new AssertionError((Object)"libgmp is loaded but kronecker returned the wrong answer");
        }
    }

    public static int kronecker(BigInteger a, BigInteger p) {
        return INSTANCE.get().kroneckerImpl(a, p);
    }

    public static BigInteger modPowInsecure(BigInteger base, BigInteger exponent, BigInteger modulus) {
        if (modulus.signum() <= 0) {
            throw new ArithmeticException("modulus must be positive");
        }
        if (base.signum() < 0) {
            throw new IllegalArgumentException("base must be non-negative");
        }
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException("exponent must be non-negative");
        }
        return INSTANCE.get().modPowInsecureImpl(base, exponent, modulus);
    }

    public static BigInteger modPowSecure(BigInteger base, BigInteger exponent, BigInteger modulus) {
        if (modulus.signum() <= 0) {
            throw new ArithmeticException("modulus must be positive");
        }
        if (!modulus.testBit(0)) {
            throw new IllegalArgumentException("modulus must be odd");
        }
        if (base.signum() < 0) {
            throw new IllegalArgumentException("base must be non-negative");
        }
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException("exponent must be non-negative");
        }
        return INSTANCE.get().modPowSecureImpl(base, exponent, modulus);
    }

    public static BigInteger modInverse(BigInteger val, BigInteger modulus) {
        if (modulus.signum() <= 0) {
            throw new ArithmeticException("modulus must be positive");
        }
        return INSTANCE.get().modInverseImpl(val, modulus);
    }

    public static BigInteger exactDivide(BigInteger dividend, BigInteger divisor) {
        if (divisor.signum() == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        return INSTANCE.get().exactDivImpl(dividend, divisor);
    }

    public static BigInteger gcd(BigInteger value1, BigInteger value2) {
        return INSTANCE.get().gcdImpl(value1, value2);
    }

    private Gmp() {
        int offset = 0;
        for (int i = 0; i < 4; ++i) {
            this.sharedOperands[i] = new LibGmp.mpz_t(this.sharedMem.share((long)offset, 16L));
            LibGmp.__gmpz_init(this.sharedOperands[i]);
            offset += 16;
        }
        this.countPtr = this.sharedMem.share((long)offset, (long)Native.SIZE_T_SIZE);
        assert ((offset += Native.SIZE_T_SIZE) == SHARED_MEM_SIZE);
    }

    private int kroneckerImpl(BigInteger a, BigInteger p) {
        LibGmp.mpz_t aPeer = this.getPeer(a, this.sharedOperands[0]);
        LibGmp.mpz_t pPeer = this.getPeer(p, this.sharedOperands[1]);
        return LibGmp.__gmpz_jacobi(aPeer, pPeer);
    }

    private BigInteger modPowInsecureImpl(BigInteger base, BigInteger exp, BigInteger mod) {
        LibGmp.mpz_t basePeer = this.getPeer(base, this.sharedOperands[0]);
        LibGmp.mpz_t expPeer = this.getPeer(exp, this.sharedOperands[1]);
        LibGmp.mpz_t modPeer = this.getPeer(mod, this.sharedOperands[2]);
        LibGmp.__gmpz_powm(this.sharedOperands[3], basePeer, expPeer, modPeer);
        int requiredSize = (mod.bitLength() + 7) / 8;
        return new BigInteger(this.mpzSgn(this.sharedOperands[3]), this.mpzExport(this.sharedOperands[3], requiredSize));
    }

    private BigInteger modPowSecureImpl(BigInteger base, BigInteger exp, BigInteger mod) {
        LibGmp.mpz_t basePeer = this.getPeer(base, this.sharedOperands[0]);
        LibGmp.mpz_t expPeer = this.getPeer(exp, this.sharedOperands[1]);
        LibGmp.mpz_t modPeer = this.getPeer(mod, this.sharedOperands[2]);
        LibGmp.__gmpz_powm_sec(this.sharedOperands[3], basePeer, expPeer, modPeer);
        int requiredSize = (mod.bitLength() + 7) / 8;
        return new BigInteger(this.mpzSgn(this.sharedOperands[3]), this.mpzExport(this.sharedOperands[3], requiredSize));
    }

    private BigInteger modInverseImpl(BigInteger val, BigInteger mod) {
        LibGmp.mpz_t modPeer;
        LibGmp.mpz_t valPeer = this.getPeer(val, this.sharedOperands[0]);
        int res = LibGmp.__gmpz_invert(this.sharedOperands[2], valPeer, modPeer = this.getPeer(mod, this.sharedOperands[1]));
        if (res == 0) {
            throw new ArithmeticException("val not invertible");
        }
        int requiredSize = (mod.bitLength() + 7) / 8;
        return new BigInteger(this.mpzSgn(this.sharedOperands[2]), this.mpzExport(this.sharedOperands[2], requiredSize));
    }

    private BigInteger exactDivImpl(BigInteger dividend, BigInteger divisor) {
        LibGmp.mpz_t dividendPeer = this.getPeer(dividend, this.sharedOperands[0]);
        LibGmp.mpz_t divisorPeer = this.getPeer(divisor, this.sharedOperands[1]);
        LibGmp.__gmpz_divexact(this.sharedOperands[2], dividendPeer, divisorPeer);
        int requiredSize = Math.max(dividend.bitLength() - divisor.bitLength() + 1, 1);
        return new BigInteger(this.mpzSgn(this.sharedOperands[2]), this.mpzExport(this.sharedOperands[2], requiredSize));
    }

    private BigInteger gcdImpl(BigInteger value1, BigInteger value2) {
        LibGmp.mpz_t value1Peer = this.getPeer(value1, this.sharedOperands[0]);
        LibGmp.mpz_t value2Peer = this.getPeer(value2, this.sharedOperands[1]);
        LibGmp.__gmpz_gcd(this.sharedOperands[2], value1Peer, value2Peer);
        int requiredSize = Math.min(value1.bitLength(), value2.bitLength());
        return new BigInteger(this.mpzSgn(this.sharedOperands[2]), this.mpzExport(this.sharedOperands[2], requiredSize));
    }

    private LibGmp.mpz_t getPeer(BigInteger value, LibGmp.mpz_t sharedPeer) {
        if (value instanceof GmpInteger) {
            return ((GmpInteger)value).getPeer();
        }
        this.mpzImport(sharedPeer, value.signum(), value.abs().toByteArray());
        return sharedPeer;
    }

    void mpzImport(LibGmp.mpz_t ptr, int signum, byte[] bytes) {
        int expectedLength = bytes.length;
        this.ensureBufferSize(expectedLength);
        this.scratchBuf.write(0L, bytes, 0, bytes.length);
        LibGmp.__gmpz_import(ptr, bytes.length, 1, 1, 1, 0, (Pointer)this.scratchBuf);
        if (signum < 0) {
            LibGmp.__gmpz_neg(ptr, ptr);
        }
    }

    private byte[] mpzExport(LibGmp.mpz_t ptr, int requiredSize) {
        this.ensureBufferSize(requiredSize);
        LibGmp.__gmpz_export((Pointer)this.scratchBuf, this.countPtr, 1, 1, 1, 0, ptr);
        int count = LibGmp.readSizeT(this.countPtr);
        byte[] result = new byte[count];
        this.scratchBuf.read(0L, result, 0, count);
        return result;
    }

    int mpzSgn(LibGmp.mpz_t ptr) {
        int result = LibGmp.__gmpz_cmp_si(ptr, ZERO);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    private void ensureBufferSize(int size) {
        if (this.scratchBuf.size() < (long)size) {
            long newSize;
            for (newSize = this.scratchBuf.size(); newSize < (long)size; newSize <<= 1) {
            }
            this.scratchBuf = new Memory(newSize);
        }
    }

    static {
        UnsatisfiedLinkError localLoadError = null;
        try {
            LibGmp.init();
        }
        catch (UnsatisfiedLinkError e) {
            localLoadError = e;
        }
        LOAD_ERROR = localLoadError;
        INSTANCE = new ThreadLocal<Gmp>(){

            @Override
            protected Gmp initialValue() {
                return new Gmp();
            }
        };
        SHARED_MEM_SIZE = 64 + Native.SIZE_T_SIZE;
        ZERO = new NativeLong();
    }
}

