/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.helpers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingStatisticsIterator
implements Iterator<GroupedTimingStatistics> {
    private Iterator<StopWatch> stopWatchIterator;
    private long timeSlice;
    private boolean createRollupStatistics;
    private Boolean hasNext = null;
    private GroupedTimingStatistics nextGroupedTimingStatistics = null;
    private GroupedTimingStatistics currentGroupedTimingStatistics = new GroupedTimingStatistics();
    private long nextTimeSliceEndTime = 0L;

    public GroupingStatisticsIterator(Iterator<StopWatch> stopWatchIterator) {
        this(stopWatchIterator, 30000L, false);
    }

    public GroupingStatisticsIterator(Iterator<StopWatch> stopWatchIterator, long timeSlice, boolean createRollupStatistics) {
        this.stopWatchIterator = stopWatchIterator;
        this.timeSlice = timeSlice;
        this.createRollupStatistics = createRollupStatistics;
        this.currentGroupedTimingStatistics.setCreateRollupStatistics(createRollupStatistics);
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            this.nextGroupedTimingStatistics = this.getNext();
            this.hasNext = this.nextGroupedTimingStatistics != null;
        }
        return this.hasNext;
    }

    @Override
    public GroupedTimingStatistics next() {
        if (Boolean.FALSE.equals(this.hasNext)) {
            throw new NoSuchElementException();
        }
        if (this.nextGroupedTimingStatistics == null) {
            this.nextGroupedTimingStatistics = this.getNext();
            if (this.nextGroupedTimingStatistics == null) {
                this.hasNext = false;
                throw new NoSuchElementException();
            }
        }
        GroupedTimingStatistics retVal = this.nextGroupedTimingStatistics;
        this.hasNext = null;
        this.nextGroupedTimingStatistics = null;
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private GroupedTimingStatistics getNext() {
        while (this.stopWatchIterator.hasNext()) {
            StopWatch stopWatch = this.stopWatchIterator.next();
            if (this.nextTimeSliceEndTime == 0L) {
                this.nextTimeSliceEndTime = stopWatch.getStartTime() / this.timeSlice * this.timeSlice + this.timeSlice;
            }
            if (stopWatch.getStartTime() >= this.nextTimeSliceEndTime) {
                this.currentGroupedTimingStatistics.setStartTime(this.nextTimeSliceEndTime - this.timeSlice);
                this.currentGroupedTimingStatistics.setStopTime(this.nextTimeSliceEndTime);
                GroupedTimingStatistics retVal = this.currentGroupedTimingStatistics;
                this.currentGroupedTimingStatistics = new GroupedTimingStatistics();
                this.currentGroupedTimingStatistics.setCreateRollupStatistics(this.createRollupStatistics);
                this.currentGroupedTimingStatistics.addStopWatch(stopWatch);
                this.nextTimeSliceEndTime = stopWatch.getStartTime() / this.timeSlice * this.timeSlice + this.timeSlice;
                return retVal;
            }
            this.currentGroupedTimingStatistics.addStopWatch(stopWatch);
        }
        if (!this.currentGroupedTimingStatistics.getStatisticsByTag().isEmpty()) {
            this.currentGroupedTimingStatistics.setStartTime(this.nextTimeSliceEndTime - this.timeSlice);
            this.currentGroupedTimingStatistics.setStopTime(this.nextTimeSliceEndTime);
            GroupedTimingStatistics retVal = this.currentGroupedTimingStatistics;
            this.currentGroupedTimingStatistics = new GroupedTimingStatistics();
            this.currentGroupedTimingStatistics.setCreateRollupStatistics(this.createRollupStatistics);
            return retVal;
        }
        return null;
    }
}

