/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.TransferWorker;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TransferPromptFilterWorker
extends TransferWorker<Map<TransferItem, TransferStatus>> {
    private static final Logger log = Logger.getLogger(TransferPromptFilterWorker.class);
    private final Transfer transfer;
    private final TransferAction action;
    private final Cache<TransferItem> cache;
    private final ProgressListener listener;

    public TransferPromptFilterWorker(Transfer transfer, TransferAction action, Cache<TransferItem> cache, ProgressListener listener) {
        this.cache = cache;
        this.action = action;
        this.transfer = transfer;
        this.listener = listener;
    }

    @Override
    public Map<TransferItem, TransferStatus> run(Session<?> source, Session<?> destination) throws BackgroundException {
        HashMap<TransferItem, TransferStatus> status = new HashMap<TransferItem, TransferStatus>();
        for (TransferItem file : this.transfer.getRoots()) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            status.put(file.getParent(), new TransferStatus().exists(true));
        }
        TransferPathFilter filter = this.transfer.filter(source, destination, this.action, this.listener);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter cache %s with filter %s", this.cache, filter));
        }
        for (TransferItem key : this.cache.keySet()) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            AttributedList<TransferItem> list = this.cache.get(key);
            for (TransferItem file : list) {
                if (this.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                boolean accept = filter.accept(file.remote, file.local, (TransferStatus)status.get(file.getParent()));
                status.put(file, filter.prepare(file.remote, file.local, (TransferStatus)status.get(file.getParent()), this.listener).reject(!accept));
            }
        }
        return status;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Apply {0} filter", "Status"), StringUtils.uncapitalize((String)this.action.getTitle()));
    }

    @Override
    public Map<TransferItem, TransferStatus> initialize() {
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferPromptFilterWorker that = (TransferPromptFilterWorker)o;
        if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
            return false;
        }
        return !(this.transfer != null ? !this.transfer.equals(that.transfer) : that.transfer != null);
    }

    public int hashCode() {
        int result = this.transfer != null ? this.transfer.hashCode() : 0;
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransferPromptFilterWorker{");
        sb.append("transfer=").append(this.transfer);
        sb.append('}');
        return sb.toString();
    }
}

