/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;

public class CreateSymlinkWorker
extends Worker<Path> {
    private final Preferences preferences = PreferencesFactory.get();
    private final Path link;
    private final Path selected;

    public CreateSymlinkWorker(Path link, Path selected) {
        this.link = link;
        this.selected = selected;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Symlink feature = session.getFeature(Symlink.class);
        if (this.preferences.getBoolean(String.format("%s.symlink.absolute", session.getHost().getProtocol().getScheme().name()))) {
            feature.symlink(this.link, this.selected.getAbsolute());
        } else {
            feature.symlink(this.link, this.selected.getName());
        }
        return this.link;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), this.link.getName());
    }
}

