/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SleepPreventer;
import ch.cyberduck.core.SleepPreventerFactory;
import ch.cyberduck.core.TransferItemCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.threading.TransferBackgroundActionState;
import ch.cyberduck.core.transfer.SynchronizingTransferErrorCallback;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.RetryTransferCallable;
import ch.cyberduck.core.worker.TransferWorker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.log4j.Logger;

public abstract class AbstractTransferWorker
extends TransferWorker<Boolean> {
    private static final Logger log = Logger.getLogger(AbstractTransferWorker.class);
    private final SleepPreventer sleep = SleepPreventerFactory.get();
    private final NotificationService notification;
    private final Transfer transfer;
    private final TransferPrompt prompt;
    private final TransferErrorCallback error;
    private final ConnectionCallback connectionCallback;
    private final PasswordCallback passwordCallback;
    private final TransferOptions options;
    private final TransferSpeedometer meter;
    private final Map<Path, TransferStatus> table;
    private final Cache<TransferItem> cache;
    private final ProgressListener progress;
    private final StreamListener stream;

    public AbstractTransferWorker(Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferSpeedometer meter, TransferErrorCallback error, ProgressListener progress, StreamListener stream, ConnectionCallback connectionCallback, PasswordCallback passwordCallback, NotificationService notification) {
        this(transfer, options, prompt, meter, error, progress, stream, connectionCallback, passwordCallback, notification, new TransferItemCache(Integer.MAX_VALUE));
    }

    public AbstractTransferWorker(Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferSpeedometer meter, TransferErrorCallback error, ProgressListener progress, StreamListener stream, ConnectionCallback connectionCallback, PasswordCallback passwordCallback, NotificationService notification, Cache<TransferItem> cache) {
        this(transfer, options, prompt, meter, error, progress, stream, connectionCallback, passwordCallback, notification, cache, new HashMap<Path, TransferStatus>());
    }

    public AbstractTransferWorker(Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferSpeedometer meter, TransferErrorCallback error, ProgressListener progress, StreamListener stream, ConnectionCallback connectionCallback, PasswordCallback passwordCallback, NotificationService notification, Cache<TransferItem> cache, Map<Path, TransferStatus> table) {
        this.transfer = transfer;
        this.options = options;
        this.prompt = prompt;
        this.meter = meter;
        this.error = new SynchronizingTransferErrorCallback(error);
        this.progress = progress;
        this.stream = stream;
        this.connectionCallback = connectionCallback;
        this.passwordCallback = passwordCallback;
        this.notification = notification;
        this.cache = cache;
        this.table = table;
    }

    protected abstract Future<TransferStatus> submit(TransferWorker.TransferCallable var1) throws BackgroundException;

    protected abstract Session<?> borrow(Connection var1) throws BackgroundException;

    protected abstract void release(Session var1, Connection var2) throws BackgroundException;

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public void reset() {
        for (TransferStatus status : this.table.values()) {
            for (TransferStatus segment : status.getSegments()) {
                segment.setCanceled();
            }
        }
    }

    @Override
    public void cancel() {
        this.reset();
        super.cancel();
    }

    public void await() throws BackgroundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Session<?> source, Session<?> destination) throws BackgroundException {
        String lock = this.sleep.lock();
        try {
            this.release(source, Connection.source);
            this.release(destination, Connection.destination);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Start transfer with prompt %s and options %s", this.prompt, this.options));
            }
            TransferAction action = this.transfer.action(source, destination, this.options.resumeRequested, this.options.reloadRequested, this.prompt, new DisabledListProgressListener(){

                @Override
                public void message(String message) {
                    AbstractTransferWorker.this.progress.message(message);
                }
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Selected transfer action %s", action));
            }
            if (action.equals(TransferAction.cancel)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Transfer %s canceled by user", this));
                }
                throw new ConnectionCanceledException();
            }
            this.transfer.reset();
            this.progress.message(MessageFormat.format(LocaleFactory.localizedString("Prepare {0} ({1})", "Status"), this.transfer.getName(), action.getTitle()));
            this.transfer.normalize();
            for (TransferItem next : this.transfer.getRoots()) {
                this.prepare(next.remote, next.local, new TransferStatus().exists(true), action);
            }
            this.await();
            this.meter.reset();
            this.transfer.pre(source, destination, this.table, this.connectionCallback);
            for (TransferItem next : this.transfer.getRoots()) {
                this.transfer(next, action);
            }
            this.await();
        }
        catch (Throwable throwable) {
            this.transfer.post(source, destination, this.table, this.connectionCallback);
            if (this.transfer.isReset()) {
                this.notification.notify(this.transfer.isComplete() ? String.format("%s complete", StringUtils.capitalize((String)this.transfer.getType().name())) : "Transfer incomplete", this.transfer.getName());
            }
            this.sleep.release(lock);
            throw throwable;
        }
        this.transfer.post(source, destination, this.table, this.connectionCallback);
        if (this.transfer.isReset()) {
            this.notification.notify(this.transfer.isComplete() ? String.format("%s complete", StringUtils.capitalize((String)this.transfer.getType().name())) : "Transfer incomplete", this.transfer.getName());
        }
        this.sleep.release(lock);
        return true;
    }

    public Future<TransferStatus> prepare(final Path file, final Local local, final TransferStatus parent, final TransferAction action) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find transfer status of %s for transfer %s", file, this));
        }
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        if (this.prompt.isSelected(new TransferItem(file, local))) {
            return this.submit(new RetryTransferCallable(){

                @Override
                public TransferStatus call() throws BackgroundException {
                    if (parent.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    Session<?> source = null;
                    Session<?> destination = null;
                    try {
                        source = AbstractTransferWorker.this.borrow(Connection.source);
                        destination = AbstractTransferWorker.this.borrow(Connection.destination);
                        TransferPathFilter filter = AbstractTransferWorker.this.transfer.filter(source, destination, action, AbstractTransferWorker.this.progress);
                        if (!filter.accept(file, local, parent)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("Skip file %s by filter %s for transfer %s", file, filter, this));
                            }
                            TransferStatus transferStatus = null;
                            return transferStatus;
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Accepted file %s in transfer %s", file, this));
                        }
                        AbstractTransferWorker.this.progress.message(MessageFormat.format(LocaleFactory.localizedString("Prepare {0} ({1})", "Status"), file.getName(), action.getTitle()));
                        TransferStatus status = filter.prepare(file, local, parent, AbstractTransferWorker.this.progress);
                        AbstractTransferWorker.this.table.put(file, status);
                        TransferItem item = new TransferItem(status.getRename().remote != null ? status.getRename().remote : file, status.getRename().local != null ? status.getRename().local : local);
                        filter.apply(item.remote, item.local, status, AbstractTransferWorker.this.progress);
                        AbstractTransferWorker.this.transfer.addSize(status.getLength() + status.getOffset());
                        AbstractTransferWorker.this.transfer.addTransferred(status.getOffset());
                        if (file.isDirectory()) {
                            List<TransferItem> children = AbstractTransferWorker.this.transfer.list(source, destination, file, local, new WorkerListProgressListener(AbstractTransferWorker.this, AbstractTransferWorker.this.progress));
                            AbstractTransferWorker.this.cache.put(item, new AttributedList<TransferItem>(children));
                            for (TransferItem f : children) {
                                AbstractTransferWorker.this.prepare(f.remote, f.local, status, action);
                            }
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Determined transfer status %s of %s for transfer %s", status, file, this));
                        }
                        TransferStatus transferStatus = status;
                        return transferStatus;
                    }
                    catch (ConnectionCanceledException e) {
                        throw e;
                    }
                    catch (BackgroundException e) {
                        if (this.retry(e, AbstractTransferWorker.this.progress, new TransferBackgroundActionState(parent))) {
                            TransferStatus transferStatus = this.call();
                            return transferStatus;
                        }
                        if (AbstractTransferWorker.this.table.size() == 0) {
                            throw e;
                        }
                        if (AbstractTransferWorker.this.error.prompt(e)) {
                            log.warn((Object)String.format("Ignore transfer failure %s", e));
                            TransferStatus transferStatus = null;
                            return transferStatus;
                        }
                        throw new ConnectionCanceledException(e);
                    }
                    finally {
                        if (source != null) {
                            AbstractTransferWorker.this.release(source, Connection.source);
                        }
                        if (destination != null) {
                            AbstractTransferWorker.this.release(destination, Connection.destination);
                        }
                    }
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder("TransferCallable{");
                    sb.append("file=").append(file);
                    sb.append(", local=").append(local);
                    sb.append('}');
                    return sb.toString();
                }
            });
        }
        log.info((Object)String.format("Skip unchecked file %s for transfer %s", file, this));
        return null;
    }

    public Future<TransferStatus> transfer(final TransferItem item, final TransferAction action) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        if (this.table.containsKey(item.remote)) {
            final TransferStatus status = this.table.get(item.remote);
            final List<TransferStatus> segments = status.getSegments();
            final Iterator<TransferStatus> iter = segments.iterator();
            while (iter.hasNext()) {
                final TransferStatus segment = iter.next();
                this.submit(new RetryTransferCallable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public TransferStatus call() throws BackgroundException {
                        block17: {
                            if (status.isCanceled()) {
                                throw new ConnectionCanceledException();
                            }
                            Session<?> source = null;
                            Session<?> destination = null;
                            try {
                                source = AbstractTransferWorker.this.borrow(Connection.source);
                                destination = AbstractTransferWorker.this.borrow(Connection.destination);
                                item.remote = AbstractTransferWorker.this.transfer.transfer(source, destination, segment.getRename().remote != null ? segment.getRename().remote : item.remote, segment.getRename().local != null ? segment.getRename().local : item.local, AbstractTransferWorker.this.options, segment, AbstractTransferWorker.this.connectionCallback, AbstractTransferWorker.this.passwordCallback, AbstractTransferWorker.this.progress, AbstractTransferWorker.this.stream);
                                if (item.remote.isDirectory()) {
                                    if (!AbstractTransferWorker.this.cache.isCached(item)) {
                                        log.warn((Object)String.format("Missing entry for %s in cache", item));
                                    }
                                    for (TransferItem f : AbstractTransferWorker.this.cache.get(item)) {
                                        AbstractTransferWorker.this.transfer(f, action);
                                    }
                                    AbstractTransferWorker.this.cache.remove(item);
                                }
                                TransferPathFilter filter = AbstractTransferWorker.this.transfer.filter(source, destination, action, AbstractTransferWorker.this.progress);
                                filter.complete(segment.getRename().remote != null ? segment.getRename().remote : item.remote, segment.getRename().local != null ? segment.getRename().local : item.local, AbstractTransferWorker.this.options, segment, AbstractTransferWorker.this.progress);
                                if (!iter.hasNext()) {
                                    AbstractTransferWorker.this.table.remove(item.remote);
                                }
                            }
                            catch (ConnectionCanceledException e) {
                                segment.setFailure();
                                throw e;
                            }
                            catch (BackgroundException e) {
                                if (this.retry(e, AbstractTransferWorker.this.progress, new TransferBackgroundActionState(status))) {
                                    segment.setRetry(this.getCount());
                                    log.info((Object)String.format("Retry %s with transfer status %s", item, segment));
                                    TransferStatus transferStatus = this.call();
                                    return transferStatus;
                                }
                                segment.setFailure();
                                if (AbstractTransferWorker.this.table.size() == 1) {
                                    throw e;
                                }
                                if (AbstractTransferWorker.this.error.prompt(e)) {
                                    log.warn((Object)String.format("Ignore transfer failure %s", e));
                                    break block17;
                                }
                                throw new ConnectionCanceledException(e);
                            }
                            finally {
                                if (source != null) {
                                    AbstractTransferWorker.this.release(source, Connection.source);
                                }
                                if (destination != null) {
                                    AbstractTransferWorker.this.release(destination, Connection.destination);
                                }
                            }
                        }
                        return segment;
                    }

                    public String toString() {
                        StringBuilder sb = new StringBuilder("TransferCallable{");
                        sb.append("status=").append(segment);
                        sb.append('}');
                        return sb.toString();
                    }
                });
            }
            return this.submit(new TransferWorker.TransferCallable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TransferStatus call() throws BackgroundException {
                    if (status.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    if (status.isSegmented()) {
                        boolean complete = true;
                        for (TransferStatus segment : segments) {
                            if (segment.await()) continue;
                            log.warn((Object)String.format("Failure to complete segment %s.", segment));
                            complete = false;
                        }
                        if (complete) {
                            Session<?> source = AbstractTransferWorker.this.borrow(Connection.source);
                            Session<?> destination = AbstractTransferWorker.this.borrow(Connection.destination);
                            try {
                                TransferPathFilter filter = AbstractTransferWorker.this.transfer.filter(source, destination, action, AbstractTransferWorker.this.progress);
                                filter.complete(status.getRename().remote != null ? status.getRename().remote : item.remote, status.getRename().local != null ? status.getRename().local : item.local, AbstractTransferWorker.this.options, status.complete(), AbstractTransferWorker.this.progress);
                            }
                            finally {
                                AbstractTransferWorker.this.release(source, Connection.source);
                                AbstractTransferWorker.this.release(destination, Connection.destination);
                            }
                        } else {
                            log.warn((Object)String.format("Skip concatenating segments for failed transfer %s", status));
                            status.setFailure();
                        }
                    }
                    return status;
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder("TransferCallable{");
                    sb.append("status=").append(status);
                    sb.append('}');
                    return sb.toString();
                }
            });
        }
        log.warn((Object)String.format("Skip file %s with unknown transfer status", item));
        return ConcurrentUtils.constantFuture(null);
    }

    @Override
    public String getActivity() {
        return BookmarkNameProvider.toString(this.transfer.getSource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractTransferWorker{");
        sb.append("transfer=").append(this.transfer);
        sb.append('}');
        return sb.toString();
    }

    protected static enum Connection {
        source,
        destination;

    }
}

