/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.synchronization.CachingComparisonServiceFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonServiceFilter;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.transfer.synchronisation.SynchronizationPathFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.log4j.Logger;

public class SyncTransfer
extends Transfer {
    private static final Logger log = Logger.getLogger(SyncTransfer.class);
    private Transfer upload;
    private Transfer download;
    private CachingComparisonServiceFilter comparison;
    private TransferAction action;
    private final TransferItem item;
    private Cache<Path> cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private final Map<TransferItem, Comparison> comparisons = Collections.synchronizedMap(new LRUMap(PreferencesFactory.get().getInteger("transfer.cache.size")));

    public SyncTransfer(Host host, TransferItem item) {
        this(host, item, TransferAction.callback);
    }

    public SyncTransfer(Host host, TransferItem item, TransferAction action) {
        super(host, Collections.singletonList(item), new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.upload.bandwidth.bytes")));
        this.init();
        this.item = item;
        this.action = action;
    }

    private void init() {
        this.upload = new UploadTransfer(this.host, this.roots).withCache(this.cache);
        this.download = new DownloadTransfer(this.host, this.roots).withCache((Cache)this.cache);
    }

    @Override
    public Transfer withCache(Cache<Path> cache) {
        this.cache = cache;
        for (TransferItem root : this.roots) {
            if (root.remote.isRoot()) continue;
            cache.put(root.remote.getParent(), new AttributedList<Path>(Collections.singletonList(root.remote)));
        }
        this.upload.withCache(cache);
        this.download.withCache(cache);
        return this;
    }

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(String.valueOf(this.getType().name()), "Type");
        dict.setObjectForKey(this.host, "Host");
        dict.setListForKey(this.roots, "Items");
        dict.setStringForKey(this.uuid, "UUID");
        dict.setStringForKey(String.valueOf(this.getSize()), "Size");
        dict.setStringForKey(String.valueOf(this.getTransferred()), "Current");
        if (this.timestamp != null) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Timestamp");
        }
        if (this.bandwidth != null) {
            dict.setStringForKey(String.valueOf(this.bandwidth.getRate()), "Bandwidth");
        }
        if (this.action != null) {
            dict.setStringForKey(this.action.name(), "Action");
        }
        return dict.getSerialized();
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.sync;
    }

    @Override
    public void setBandwidth(float bytesPerSecond) {
        this.upload.setBandwidth(bytesPerSecond);
        this.download.setBandwidth(bytesPerSecond);
    }

    @Override
    public String getName() {
        return this.getRoot().remote.getName() + " \u2194 " + this.getRoot().local.getName();
    }

    @Override
    public Long getTransferred() {
        return super.getTransferred() + this.download.getTransferred() + this.upload.getTransferred();
    }

    @Override
    public TransferPathFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter transfer with action %s", action));
        }
        this.comparison = new CachingComparisonServiceFilter(new ComparisonServiceFilter(source, source.getHost().getTimezone(), listener).withCache(this.cache)).withCache(this.comparisons);
        return new SynchronizationPathFilter(this.comparison, this.download.filter(source, destination, TransferAction.overwrite, listener), this.upload.filter(source, destination, TransferAction.overwrite, listener), action).withCache(this.cache);
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<Path, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
    }

    @Override
    public List<TransferItem> list(Session<?> source, Session<?> destination, Path directory, Local local, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Children for %s", directory));
        }
        HashSet<TransferItem> children = new HashSet<TransferItem>();
        Find finder = ((Find)source.getFeature(Find.class, new DefaultFindFeature(source))).withCache(this.cache);
        if (finder.find(directory)) {
            children.addAll(this.download.list(source, destination, directory, local, listener));
        }
        if (local.exists()) {
            children.addAll(this.upload.list(source, destination, directory, local, listener));
        }
        return new ArrayList<TransferItem>(children);
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            if (this.action.equals(TransferAction.callback)) {
                this.action = prompt.prompt(this.item);
                return this.action;
            }
            return this.action;
        }
        this.action = prompt.prompt(this.item);
        return this.action;
    }

    @Override
    public Path transfer(Session<?> source, Session<?> destination, Path file, Local local, TransferOptions options, TransferStatus status, ConnectionCallback connectionCallback, PasswordCallback passwordCallback, ProgressListener progressListener, StreamListener streamListener) throws BackgroundException {
        Comparison compare;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Transfer file %s with options %s", file, options));
        }
        if ((compare = this.comparison.compare(file, local)).equals((Object)Comparison.remote)) {
            this.download.pre(source, destination, Collections.singletonMap(file, status), connectionCallback);
            this.download.transfer(source, destination, file, local, options, status, connectionCallback, passwordCallback, progressListener, streamListener);
        } else if (compare.equals((Object)Comparison.local)) {
            this.upload.pre(source, destination, Collections.singletonMap(file, status), connectionCallback);
            this.upload.transfer(source, destination, file, local, options, status, connectionCallback, passwordCallback, progressListener, streamListener);
        }
        return file;
    }

    public Comparison compare(TransferItem item) {
        if (null == this.comparison) {
            log.warn((Object)"No comparison filter initialized");
            return Comparison.equal;
        }
        return this.comparison.get(item);
    }

    @Override
    public void start() {
        this.download.start();
        this.upload.start();
        super.start();
    }

    @Override
    public void stop() {
        this.download.stop();
        this.upload.stop();
        this.cache.clear();
        this.comparisons.clear();
        super.stop();
    }

    @Override
    public void reset() {
        this.download.reset();
        this.upload.reset();
        super.reset();
    }

    @Override
    public void normalize() {
        this.download.normalize();
        this.upload.normalize();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SyncTransfer{");
        sb.append("upload=").append(this.upload);
        sb.append(", download=").append(this.download);
        sb.append('}');
        return sb.toString();
    }
}

