/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Deserializer;
import org.apache.commons.lang3.StringUtils;

public class LocalDictionary {
    private final DeserializerFactory deserializer;

    public LocalDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public LocalDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> Local deserialize(T serialized) {
        Deserializer dict = this.deserializer.create(serialized);
        String path = dict.stringForKey("Path");
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        Local file = LocalFactory.get(path);
        if (StringUtils.isNotBlank((CharSequence)dict.stringForKey(String.format("%s Bookmark", PreferencesFactory.get().getProperty("application.name"))))) {
            file.setBookmark(dict.stringForKey(String.format("%s Bookmark", PreferencesFactory.get().getProperty("application.name"))));
        } else if (StringUtils.isNotBlank((CharSequence)dict.stringForKey("Bookmark"))) {
            file.setBookmark(dict.stringForKey("Bookmark"));
        }
        return file;
    }
}

