/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.StreamCloseTimeoutException;
import ch.cyberduck.core.io.StreamCloser;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.NamedThreadFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public class ThreadedStreamCloser
implements StreamCloser {
    private final Preferences preferences = PreferencesFactory.get();
    private final ThreadFactory threadFactory = new NamedThreadFactory("close");

    @Override
    public void close(final InputStream in) throws ConnectionTimeoutException {
        final CountDownLatch signal = new CountDownLatch(1);
        this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                IOUtils.closeQuietly((InputStream)in);
                signal.countDown();
            }
        }).start();
        try {
            if (!signal.await(this.preferences.getInteger("connection.timeout.seconds"), TimeUnit.SECONDS)) {
                throw new StreamCloseTimeoutException("Timeout closing input stream", null);
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionTimeoutException(e.getMessage(), e);
        }
    }

    @Override
    public void close(final OutputStream out) throws ConnectionTimeoutException {
        final CountDownLatch signal = new CountDownLatch(1);
        this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                IOUtils.closeQuietly((OutputStream)out);
                signal.countDown();
            }
        }).start();
        try {
            if (!signal.await(this.preferences.getInteger("connection.timeout.seconds"), TimeUnit.SECONDS)) {
                throw new StreamCloseTimeoutException("Timeout closing output stream", null);
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionTimeoutException(e.getMessage(), e);
        }
    }
}

