/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.auth;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.sftp.auth.SFTPPublicKeyAuthentication;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPChallengeResponseAuthentication
implements AuthenticationProvider<Boolean> {
    private static final Logger log = Logger.getLogger(SFTPChallengeResponseAuthentication.class);
    private static final Pattern DEFAULT_PROMPT_PATTERN = Pattern.compile(".*[pP]assword.*", 32);
    private final SFTPSession session;

    public SFTPChallengeResponseAuthentication(SFTPSession session) {
        this.session = session;
    }

    public Boolean authenticate(final Host bookmark, HostPasswordStore keychain, final LoginCallback callback, CancelCallback cancel) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Login using challenge response authentication for %s", bookmark));
        }
        final AtomicBoolean canceled = new AtomicBoolean();
        final AtomicBoolean publickey = new AtomicBoolean();
        try {
            final Credentials credentials = bookmark.getCredentials();
            ((SSHClient)this.session.getClient()).auth(credentials.getUsername(), new AuthMethod[]{new AuthKeyboardInteractive(new ChallengeResponseProvider(){
                private String name = "";
                private String instruction = "";

                public List<String> getSubmethods() {
                    return Collections.emptyList();
                }

                public void init(Resource resource, String name, String instruction) {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{instruction})) {
                        this.instruction = instruction;
                    }
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                        this.name = name;
                    }
                }

                public char[] getResponse(String prompt, boolean echo) {
                    Credentials additional;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Reply to challenge name %s with instruction %s", this.name, this.instruction));
                    }
                    if (DEFAULT_PROMPT_PATTERN.matcher(prompt).matches()) {
                        if (StringUtils.isBlank((CharSequence)credentials.getPassword())) {
                            try {
                                Credentials input = callback.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString((String)"Login", (String)"Login"), bookmark.getHostname()), MessageFormat.format(LocaleFactory.localizedString((String)"Login {0} with username and password", (String)"Credentials"), BookmarkNameProvider.toString((Host)bookmark)), new LoginOptions(bookmark.getProtocol()).user(false));
                                if (input.isPublicKeyAuthentication()) {
                                    credentials.setIdentity(input.getIdentity());
                                    publickey.set(true);
                                    return "".toCharArray();
                                }
                                credentials.setSaved(input.isSaved());
                                credentials.setPassword(input.getPassword());
                            }
                            catch (LoginCanceledException e) {
                                canceled.set(true);
                                return "".toCharArray();
                            }
                        }
                        return credentials.getPassword().toCharArray();
                    }
                    StringAppender message = new StringAppender().append(this.instruction).append(prompt);
                    try {
                        StringAppender title = new StringAppender().append(this.name).append(LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"));
                        additional = callback.prompt(bookmark, title.toString(), message.toString(), new LoginOptions(bookmark.getProtocol()).user(false).publickey(false).keychain(false));
                    }
                    catch (LoginCanceledException e) {
                        canceled.set(true);
                        return "".toCharArray();
                    }
                    return additional.getPassword().toCharArray();
                }

                public boolean shouldRetry() {
                    return false;
                }
            })});
        }
        catch (IOException e) {
            if (publickey.get()) {
                return new SFTPPublicKeyAuthentication(this.session).authenticate(bookmark, keychain, callback, cancel);
            }
            if (canceled.get()) {
                throw new LoginCanceledException();
            }
            throw new SFTPExceptionMappingService().map(e);
        }
        return ((SSHClient)this.session.getClient()).isAuthenticated();
    }

    public String getMethod() {
        return "keyboard-interactive";
    }
}

