/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.resources;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.AbstractIconCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class NSImageIconCache
extends AbstractIconCache<NSImage> {
    private static final Logger log = Logger.getLogger(NSImageIconCache.class);
    private static final NSRect NSZeroRect = new NSRect(0.0, 0.0);
    private final Map<String, NSImage> cache = 0 == PreferencesFactory.get().getInteger("icon.cache.size") ? new HashMap<String, NSImage>(){

        @Override
        public NSImage put(String key, NSImage value) {
            return value;
        }
    } : new LRUMap<String, NSImage>(PreferencesFactory.get().getInteger("icon.cache.size")){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing from cache:" + entry));
            }
            return true;
        }
    };

    private NSImage put(String name, NSImage image, Integer size) {
        this.cache.put(String.format("%d-%s", size, name), image);
        return image;
    }

    private NSImage load(String name, Integer size) {
        if (!this.cache.containsKey(String.format("%d-%s", size, name))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No cached image for %s", name));
            }
            return null;
        }
        return this.cache.get(String.format("%d-%s", size, name));
    }

    public NSImage documentIcon(String extension, Integer size) {
        NSImage image = this.load(extension, size);
        if (null == image) {
            image = NSWorkspace.sharedWorkspace().iconForFileType(extension);
            image = this.convert(extension, image, size);
            this.put(extension, image, size);
        }
        return image;
    }

    public NSImage documentIcon(String extension, Integer size, NSImage badge) {
        String name = extension + badge.name();
        NSImage icon = (NSImage)this.iconNamed(name, size);
        if (null == icon) {
            icon = this.badge(badge, this.documentIcon(extension, size));
            this.put(name, icon, size);
        }
        return icon;
    }

    public NSImage folderIcon(Integer size) {
        NSImage folder = (NSImage)this.iconNamed("NSFolder", size);
        if (null == folder) {
            return (NSImage)this.iconNamed("NSFolder", size);
        }
        return folder;
    }

    public NSImage folderIcon(Integer size, NSImage badge) {
        String name = String.format("NSFolder-%s", badge.name());
        NSImage folder = this.load(name, size);
        if (null == folder) {
            folder = this.convert(name, (NSImage)this.iconNamed("NSFolder", size), size);
            folder = this.badge(badge, folder);
            this.put(name, folder, size);
        }
        return folder;
    }

    protected NSImage badge(NSImage badge, NSImage icon) {
        NSImage f = NSImage.imageWithSize((NSSize)icon.size());
        f.lockFocus();
        icon.drawInRect(new NSRect(new NSPoint(0.0, 0.0), icon.size()), NSZeroRect, 2, 1.0);
        badge.drawInRect(new NSRect(new NSPoint(0.0, 0.0), badge.size()), NSZeroRect, 2, 1.0);
        f.unlockFocus();
        return f;
    }

    public NSImage iconNamed(String image, Integer size, NSImage badge) {
        String name = String.format("%s-%s", image, badge.name());
        NSImage icon = this.load(name, size);
        if (null == icon) {
            icon = this.convert(name, (NSImage)this.iconNamed(image, size), size);
            icon = this.badge(badge, icon);
            this.put(name, icon, size);
        }
        return icon;
    }

    public NSImage iconNamed(String name, Integer width, Integer height) {
        NSImage image = this.load(name, width);
        if (null == image) {
            if (null == name) {
                return this.iconNamed("notfound.tiff", width, height);
            }
            if (name.startsWith("/")) {
                image = NSImage.imageWithContentsOfFile((String)name);
            } else {
                image = NSImage.imageNamed((String)String.format("%d-%s", width, name));
                if (null == image) {
                    image = NSImage.imageNamed((String)name);
                } else {
                    return image;
                }
            }
            if (null == image) {
                log.warn((Object)String.format("No icon named %s", name));
                this.put(name, null, width);
            } else {
                image = this.convert(name, image, width, height);
                this.put(name, image, width);
            }
        }
        return image;
    }

    public NSImage fileIcon(Local file, Integer size) {
        NSImage icon = null;
        if (file.exists() && null == (icon = this.load(file.getAbsolute(), size))) {
            icon = NSWorkspace.sharedWorkspace().iconForFile(file.getAbsolute());
            icon = this.convert(file.getName(), icon, size);
            this.put(file.getAbsolute(), icon, size);
        }
        if (null == icon) {
            return (NSImage)this.iconNamed("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage applicationIcon(Application app, Integer size) {
        String path;
        NSImage icon = this.load(app.getIdentifier(), size);
        if (null == icon && StringUtils.isNotBlank((CharSequence)(path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(app.getIdentifier())))) {
            icon = NSWorkspace.sharedWorkspace().iconForFile(path);
            icon = this.convert(app.getIdentifier(), icon, size);
            this.put(app.getIdentifier(), icon, size);
        }
        if (null == icon) {
            return (NSImage)this.iconNamed("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage fileIcon(Path file, Integer size) {
        if (file.getType().contains(AbstractPath.Type.decrypted)) {
            NSImage badge = (NSImage)this.iconNamed("unlockedbadge.tiff", size);
            badge.setName("unlockedbadge");
            if (file.isDirectory()) {
                return this.folderIcon(size, badge);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size, badge);
        }
        if (file.isSymbolicLink()) {
            NSImage badge = (NSImage)this.iconNamed("aliasbadge.tiff", size);
            badge.setName("aliasbadge");
            if (file.isDirectory()) {
                return this.folderIcon(size, badge);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size, badge);
        }
        if (file.isFile()) {
            if (StringUtils.isEmpty((CharSequence)file.getExtension()) && file.attributes().getPermission().isExecutable()) {
                return (NSImage)this.iconNamed("executable.tiff", size);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size);
        }
        if (file.isDirectory()) {
            if (Permission.EMPTY != file.attributes().getPermission()) {
                if (!file.attributes().getPermission().isExecutable()) {
                    NSImage badge = (NSImage)this.iconNamed("privatefolderbadge.tiff", size);
                    badge.setName("privatefolderbadge");
                    return this.folderIcon(size, badge);
                }
                if (!file.attributes().getPermission().isReadable() && file.attributes().getPermission().isWritable()) {
                    NSImage badge = (NSImage)this.iconNamed("dropfolderbadge.tiff", size);
                    badge.setName("dropfolderbadge");
                    return this.folderIcon(size, badge);
                }
                if (!file.attributes().getPermission().isWritable()) {
                    NSImage badge = (NSImage)this.iconNamed("readonlyfolderbadge.tiff", size);
                    badge.setName("readonlyfolderbadge");
                    return this.folderIcon(size, badge);
                }
            }
            return this.folderIcon(size);
        }
        return (NSImage)this.iconNamed("notfound.tiff", size);
    }

    private NSImage convert(String name, NSImage icon, Integer size) {
        return this.convert(name, icon, size, size);
    }

    private NSImage convert(String name, NSImage icon, Integer width, Integer height) {
        if (null == width || null == height) {
            log.debug((Object)String.format("Return default size for %s", icon.name()));
            return icon;
        }
        icon.setName(String.format("%d-%s", width, name));
        icon.setSize(new NSSize((double)width.intValue(), (double)height.intValue()));
        return icon;
    }
}

